package com.ovopark.open.api.doc;

import com.coco.sdk.annotation.ApiDoc;
import com.coco.sdk.annotation.ApiPara;
import com.coco.sdk.annotation.ApiRef;
import com.coco.sdk.annotation.ResponseEntity;
import com.coco.sdk.annotation.ReturnCodeEntity;
import com.coco.sdk.common.Const;
import com.ovopark.open.api.doc.support.FaceAddGroupCode;
import com.ovopark.open.api.doc.support.FaceAddGroupResp;
import com.ovopark.open.api.doc.support.FaceAddResp;
import com.ovopark.open.api.doc.support.FaceAddRespCode;
import com.ovopark.open.api.doc.support.FaceBindingDeviceCode;
import com.ovopark.open.api.doc.support.FaceQueryDeviceCode;
import com.ovopark.open.api.doc.support.FaceQueryDeviceResp;
import com.ovopark.open.api.doc.support.FaceQueryGroupCode;
import com.ovopark.open.api.doc.support.FaceQueryGroupResp;
import com.ovopark.open.api.doc.support.FaceQueryResp;
import com.ovopark.open.api.doc.support.FaceQueryUserRespCode;
import com.ovopark.open.api.doc.support.FaceUpdateUserCode;

@ApiDoc(name="face",value="人脸接口",Desc="万店掌人脸识别系统,查看“刷脸”后各项数据，包括年龄、性别、会员身份、消费记录以及个人消费偏好等。用最直观的方式了解高科技是如何助力企业完成精准营销的",owner = "万店掌")
public interface FaceDoc {
	
	@ApiRef(version=Const.VERSION_1,method="open.face.addUser",url="http://openapi.ovopark.com/shopweb-support/api/face/v1/addUser", desc = "开发者注册会员至万店掌人脸平台", value = "添加用户",owner = "万店掌")
	@ResponseEntity(entity=FaceAddResp.class)
	@ReturnCodeEntity(entity=FaceAddRespCode.class)
	void addUser(
			@ApiPara(required=true,maxlength="-",name="DataUser",type="JSON",desc="由于人脸新增需要对比，故每次批量提交不要超过《=5条，数据格式为JSON格式，下面为json中每个属性定义，具体格式请参考示例",
			eg="[{\"orgid\":206,\"departno\":833,\"checkrepeat\":1,\"memberType\":\"2\",\"gender\":\"1\",\"mobilephone\":\"13800000001\",\"userid\":\"0000000001\",\"thirdpicurl\":\"http://xxx/img/001.jpg\",\"username\":\"张三\"},{\"orgid\":206,\"departno\":833,\"checkrepeat\":1,\"memberType\":\"2\",\"gender\":\"1\",\"mobilephone\":\"13800000002\",\"userid\":\"0000000002\",\"thirdpicurl\":\"http://xxx/img/002.jpg\",\"username\":\"李四\"},{\"orgid\":206,\"departno\":833,\"checkrepeat\":1,\"memberType\":\"2\",\"gender\":\"1\",\"mobilephone\":\"13800000003\",\"userid\":\"0000000003\",\"thirdpicurl\":\"http://xxx/img/003.jpg\",\"username\":\"王五\"}]") String DataUser,
			@ApiPara(required=true,maxlength="11",name="orgid",type="int",desc="企业id",eg="206") String orgid,
			@ApiPara(required=true,maxlength="11",name="departno",type="int",desc="分组id(即groupid)",eg="833") String departno,
			@ApiPara(required=true,maxlength="128",name="userid",type="String",desc="开发者提供的会员id(第三方系统自行生成)，唯一",eg="0000000001") String userid,
			@ApiPara(required=true,maxlength="500",name="thirdpicurl",type="String",desc="开发者提供的公网可以访问的图片url地址",eg="http://www.ovopark.com/static/img/contact_company_member_00.923069c.jpg") String thirdpicurl,
			@ApiPara(required=false,maxlength="128",name="username",type="String",desc="用户姓名",eg="张三") String username,
			@ApiPara(required=false,maxlength="2",name="memberType",type="String",desc="用户类别(0：新顾客；1：会员；2：店员)",eg="2") String memberType,
			@ApiPara(required=false,maxlength="11",name="mobilephone",type="String",desc="手机号码",eg="18662250114") String mobilephone,
			@ApiPara(required=false,maxlength="2",name="gender",type="String",desc="性别,主要做校准使用(0:男,1：女)",eg="0") String gender,
			@ApiPara(required=false,maxlength="2",name="checkrepeat",type="int",desc="验证手机号是否重复, 需要验证为1，不需要验证为0)",eg="1") String checkrepeat
			);
	
	@ApiRef(version=Const.VERSION_1,method="open.face.updateUser",url="http://openapi.ovopark.com/shopweb-support/api/face/v1/updateUser", desc = "开发者更新会员至万店掌人脸平台", value = "更新用户",owner = "万店掌")
	@ReturnCodeEntity(entity=FaceUpdateUserCode.class)
	void updateUser(
			@ApiPara(required=true,maxlength="11",name="orgid",type="int",desc="企业id",eg="206") String orgid,
			@ApiPara(required=true,maxlength="11",name="departno",type="int",desc="分组id(即groupid)",eg="833") String departno,
			@ApiPara(required=true,maxlength="128",name="userid",type="String",desc="开发者提供的会员id(第三方系统自行生成)，唯一",eg="0000000001") String userid,
			@ApiPara(required=true,maxlength="500",name="thirdpicurl",type="String",desc="开发者提供的公网可以访问的图片url地址",eg="http://www.ovopark.com/static/img/contact_company_member_00.923069c.jpg") String thirdpicurl,
			@ApiPara(required=false,maxlength="128",name="username",type="String",desc="用户姓名",eg="张三") String username,
			@ApiPara(required=false,maxlength="2",name="memberType",type="String",desc="用户类别(0：新顾客；1：会员；2：店员)",eg="2") String memberType,
			@ApiPara(required=false,maxlength="11",name="mobilephone",type="String",desc="手机号码",eg="18662250114") String mobilephone,
			@ApiPara(required=false,maxlength="2",name="gender",type="String",desc="性别,主要做校准使用(0:男,1：女)",eg="0") String gender,
			@ApiPara(required=false,maxlength="2",name="checkrepeat",type="int",desc="验证手机号是否重复, 需要验证为1，不需要验证为0)",eg="1") String checkrepeat
			);
	
	
	@ApiRef(version=Const.VERSION_1,interfaceType=Const.INTERFACETYPE_DOWN,method="open.face.queryUserCallBack",url="当万店掌人脸仪拍到人脸后，将人脸比对结果返回到开发者网站，页面返回地址是第三方提供的 queryUserCallBackUrl", desc = "当万店掌摄像头捕捉到进店人脸照片后，将顾客信息回调至第三方客户端", value = "查询用户",owner = "万店掌")
	@ResponseEntity(entity=FaceQueryResp.class)
	@ReturnCodeEntity(entity=FaceQueryUserRespCode.class)
	void  queryUser();
	
	@ApiRef(version=Const.VERSION_1,method="open.face.addGroup",url="http://openapi.ovopark.com/shopweb-support/api/face/v1/addGroup", desc = "开发者添加人脸分组信息", value = "添加分组",owner = "万店掌")
	@ResponseEntity(entity=FaceAddGroupResp.class)
	@ReturnCodeEntity(entity=FaceAddGroupCode.class)
	void addGroup(
			@ApiPara(required=true,maxlength="100",name="groupname",type="String",desc="分组名称",eg="苏州园区店") String groupname,
			@ApiPara(required=true,maxlength="11",name="orgid",type="int",desc="企业id",eg="206") String orgid
			);
	
	@ApiRef(version=Const.VERSION_1,method="open.face.queryGroup",url="http://openapi.ovopark.com/shopweb-support/api/face/v1/queryGroup", desc = "开发者查询人脸分组信息", value = "查询分组",owner = "万店掌")
	@ResponseEntity(entity=FaceQueryGroupResp.class)
	@ReturnCodeEntity(entity=FaceQueryGroupCode.class)
	void queryGroup(
			@ApiPara(required=true,maxlength="11",name="orgid",type="int",desc="企业id",eg="206") String orgid
			);
	
	@ApiRef(version=Const.VERSION_1,method="open.face.queryDevice",url="http://openapi.ovopark.com/shopweb-support/api/face/v1/queryDevice", desc = "开发者查询人脸设备列表信息", value = "查询人脸设备",owner = "万店掌")
	@ResponseEntity(entity=FaceQueryDeviceResp.class)
	@ReturnCodeEntity(entity=FaceQueryDeviceCode.class)
	void queryDevice(
			@ApiPara(required=true,maxlength="11",name="orgid",type="int",desc="企业id",eg="206") String orgid
			);
	
	@ApiRef(version=Const.VERSION_1,method="open.face.bindingDevice",url="http://openapi.ovopark.com/shopweb-support/api/face/v1/bindingDevice", desc = "开发者绑定人脸设备和分组的关系", value = "绑定人脸设备",owner = "万店掌")
	@ReturnCodeEntity(entity=FaceBindingDeviceCode.class)
	void bindingDevice(
			@ApiPara(required=true,maxlength="11",name="orgid",type="int",desc="企业id",eg="206") String orgid,
			@ApiPara(required=true,maxlength="11",name="groupid",type="int",desc="分组id",eg="9443") String groupid,
			@ApiPara(required=true,maxlength="11",name="deviceId",type="int",desc="设备id",eg="9409") String device_id
			);
}
