package com.ovopark.open.api.doc;

import com.coco.sdk.annotation.ApiDoc;
import com.coco.sdk.annotation.ApiPara;
import com.coco.sdk.annotation.ApiRef;
import com.coco.sdk.common.Const;

@ApiDoc(name="screen",value="大屏接口",Desc="通过万店掌人脸识别技术结合开发者自身业务CRM系统，将会员,店员,新顾客,熟客的信息进行定制展示呈现",owner = "万店掌")
public interface ScreenDoc {
	@ApiRef(version=Const.VERSION_1,method="open.screen.postScreen",url="http://www.ovopark.com/service/postFaceEvent.action", desc = "开发者将自身CRM系统的会员信息推送给万店掌大屏", value = "大屏推送",owner = "万店掌")
	void postScreen(
			@ApiPara(required=true,maxlength="100",name="userid",type="String",desc="用户id",eg="1") String userid,
			@ApiPara(required=true,maxlength="100",name="username",type="String",desc="用户名称",eg="1") String username,
			@ApiPara(required=false,maxlength="11",name="age",type="int",desc="年龄",eg="30") String age,
			@ApiPara(required=true,maxlength="100",name="deviceMac",type="String",desc="设备mac",eg="C81114664216") String deviceMac,
			@ApiPara(required=false,maxlength="100",name="mobilephone",type="String",desc="手机号码",eg="18662250114") String mobilephone,
			@ApiPara(required=false,maxlength="11",name="gender",type="int",desc="性别(0:男,1：女)",eg="0") String gender,
			@ApiPara(required=true,maxlength="100",name="memberUrl",type="String",desc="会员头像",eg="http://openapi.ovopark.com/static/wyz.jpg") String memberUrl,
			@ApiPara(required=true,maxlength="100",name="arriveUrl",type="String",desc="到店头像",eg="http://openapi.ovopark.com/static/wyz2.jpg") String arriveUrl,
			@ApiPara(required=true,maxlength="100",name="arriveTime",type="String",desc="到店时间",eg="2018-01-18 16:51:24") String arriveTime,
			@ApiPara(required=true,maxlength="100",name="lastTime",type="String",desc="上次到店时间",eg="2017-09-30 16:51:24") String lastTime,
			@ApiPara(required=false,maxlength="100",name="cardNumber",type="String",desc="用户卡号",eg="card123") String cardNumber,
			@ApiPara(required=true,maxlength="100",name="memberType",type="String",desc="用户类别(0：新顾客；1：会员；2：店员；3：熟客)",eg="1") String memberType,
			@ApiPara(required=true,maxlength="11",name="times",type="int",desc="到店次数",eg="18") String times,
			@ApiPara(required=true,maxlength="11",name="todayTotal",type="int",desc="今日第几位到店顾客",eg="100") String todayTotal,
			@ApiPara(required=true,maxlength="100",name="qrcodeUrl",type="String",desc="动态二维码URL",eg="http://www.ovopark.com/xxx/user/addUser") String qrcodeUrl
			);
			
}
