package com.ovopark.open.api.entity.code;

import java.io.Serializable;
/**
    * @ClassName: AbstractReturnCode
    * @Description: TODO(返回码抽象类，用于api网关返回码重载构造方法)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date 2017年9月14日 上午11:30:34
 */
public class AbstractReturnCode  implements Serializable {
	private static final long serialVersionUID = 5318397036868438744L;
    private       String name;
    private final String desc;
    private final int    code;

    private       String             service;
    private final AbstractReturnCode display;
	 /**
     * 初始化一个对外暴露的ReturnCode(用于客户端异常处理)
     */
    public AbstractReturnCode(String desc,String name, int code) {
        this.desc = desc;
        this.name = name;
        this.code = code;
        this.display = this;
    }
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getService() {
		return service;
	}
	public void setService(String service) {
		this.service = service;
	}
	public String getDesc() {
		return desc;
	}
	public int getCode() {
		return code;
	}
	public AbstractReturnCode getDisplay() {
		return display;
	}
	//日志输出用..
	public String dolog() {
		return "AbstractReturnCode [desc=" + desc + ", code=" + code + "]";
	}
	
	
    
}
