package com.ovopark.open.api.entity.code;

/**
 * 
    * @ClassName: ApiReturnCode
    * @Description: TODO(网关返回码)
    * @author Remiel_Mercy xuefei_fly@126.com
    * @date 2017年9月14日 上午11:17:31
    * 
    * 错误码区间 eg:100001(前3位为系统编号，如当前系统编号，如当前系统编号为100，后三位为异常码如001)
 */
public class ApiReturnCode extends AbstractReturnCode{
	private static final long serialVersionUID = -1477827287408858436L;
	//成功
	public static final int SUCCESS_CODE=0;	
	public final static AbstractReturnCode SUCCESS = new ApiReturnCode("成功","SUCCESS", SUCCESS_CODE);
	
	//成功
	public static final int ADD_SUCCESS_CODE=100000;	
	public final static AbstractReturnCode ADD_SUCCESS = new ApiReturnCode("会员添加成功","ADD_SUCCESS", ADD_SUCCESS_CODE);
	
	//数据异常
	public static final int DATA_FALED_CODE=100001;	
	public final static AbstractReturnCode DATA_FALED = new ApiReturnCode("JSON数据异常","DATA_FALED", DATA_FALED_CODE);
	
	//非空验证不通过
	public static final int DATA_NOT_NULL_CODE=100002;	
	public final static AbstractReturnCode DATA_NOT_NULL = new ApiReturnCode("必填字段不能为空","DATA_NOT_NULL", DATA_NOT_NULL_CODE);
	
	//手机号重复
	public static final int PHONE_ALREADY_EXIST_CODE=100003;	
	public final static AbstractReturnCode PHONE_ALREADY_EXIST = new ApiReturnCode("手机号已经存在","PHONE_ALREADY_EXIST", PHONE_ALREADY_EXIST_CODE);
	
	//人脸服务器异常
	public static final int FACE_SEVER_ERROR_CODE=100004;	
	public final static AbstractReturnCode FACE_SEVER_ERROR = new ApiReturnCode("人脸服务器通讯异常","FACE_SEVER_ERROR", FACE_SEVER_ERROR_CODE);
	
	//身份信息违法，密匙秘钥与企业id不匹配
	public static final int IDENTITY_INFORMATION_WRONG_CODE=100005;	
	public final static AbstractReturnCode IDENTITY_INFORMATION_WRONG = new ApiReturnCode("身份信息有误,_akey、_asid与企业id不匹配","IDENTITY_INFORMATION_WRONG", IDENTITY_INFORMATION_WRONG_CODE);
	
	//组织机构代码不能为空
    public static final int ORGID_NOT_NULL_CODE=100006;	
	public final static AbstractReturnCode ORGID_NOT_NULL = new ApiReturnCode("组织机构代码不能为空","ORGID_NOT_NULL", ORGID_NOT_NULL_CODE);
	//该组织机构没有权限
	public static final int NO_PERMISSION_CODE=100007;	
	public final static AbstractReturnCode NO_PERMISSION = new ApiReturnCode("没有权限","NO_PERMISSION", NO_PERMISSION_CODE);
		
	//api服务异常
	public static final int API_SYSTEM_ERROR_CODE=100999;	
	public final static AbstractReturnCode API_SYSTEM_ERROR = new ApiReturnCode("api服务未知异常","API_SYSTEM_ERROR", API_SYSTEM_ERROR_CODE);
	
	
	protected ApiReturnCode(String desc,String name, int code) {
	        super(desc,name, code);
	}
	
	
}
