package com.ovopark.open.common;

import java.text.DecimalFormat;
import java.util.UUID;

import com.ovopark.cloud.core.kit.StrKit;

public class GenerateOpenKey {
	private static final  String firstKey="S107-00000001";
	private static final  String aid="S107";
	private static final  String line="-";
	static final String SALT_1 = "{ovopark:open->}";
	static final String SALT_2 = "{<-ovopark:open}";
	/**线程安全实现**/
	private enum OpenKey{
		instance;
		private GenerateOpenKey openkey;
		OpenKey(){
			openkey=new GenerateOpenKey();
		}
		private GenerateOpenKey init(){
	        return openkey;
	    }
	}
	public static GenerateOpenKey create() {
		return OpenKey.instance.init();
	}
	/**
	    * @Title: generaterOpenKey
	    * @Description: TODO(生成下一个密匙)
	    * @param @param maxKey 当前最大密匙
	    * @param @return    参数
	    * @return String    返回类型
	    * @throws
	 */
	public String generaterOpenKey(String maxKey){
		String prefix=aid+line;
		String nextKey="";
		if(StrKit.isBlank(maxKey)){
			nextKey=firstKey;
		}else{
	        DecimalFormat df = new DecimalFormat("00000000");
	        nextKey = prefix+df.format(1 + Integer.parseInt(maxKey.substring((prefix.length()), maxKey.length())));
		}
		return nextKey;
	}
	/**
	    * @Title: generaterOpenSecret
	    * @Description: TODO(根据密匙生成秘钥)
	    * @param @param aid
	    * @param @return    参数
	    * @return String    返回类型
	    * @throws
	 */
	public String generaterOpenSecret(String akey){
		String guid = guid();
		String key =  SALT_1+akey+guid+SALT_2;
		String asid = Md5Util.computeToHex(key.getBytes());
		return asid;
	}
	private  String guid() {
		UUID uuid = UUID.randomUUID();
		String key = uuid.toString();
		return key;
	}
	public static void main(String[] args) {
		String key=GenerateOpenKey.create().generaterOpenKey("S107-15433213");
		System.out.println(key);
	}
}
