package com.ovopark.open.common;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

import javax.imageio.ImageIO;

import org.apache.commons.lang3.StringUtils;

import com.ovopark.cloud.cache.ehCache.CoCoEhCacheKit;
import com.ovopark.cloud.cache.redis.CoCoRedisKit;


/**
 * 
 * @use java给图片添加水印文字
 * @JDK 1.6.0 </br>
 * @Version 1.0 </br>
 */
public class ImageUtils {
	public static Random random = new Random();

	/**
	 * 图片添加水印
	 * 
	 * @param srcImgPath
	 *            需要添加水印的图片的路径
	 * @param outImgPath
	 *            添加水印后图片输出路径
	 * @param markContentColor
	 *            水印文字的颜色
	 * @param waterMarkContent
	 *            水印的文字
	 */
	public static void mark(String srcImgPath, String outImgPath, Color markContentColor, String waterMarkContent) {
		try {
			// 读取原图片信息
			File srcImgFile = new File(srcImgPath);
			Image srcImg = ImageIO.read(srcImgFile);
			int srcImgWidth = srcImg.getWidth(null);
			int srcImgHeight = srcImg.getHeight(null);
			// 加水印
			BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, BufferedImage.TYPE_INT_RGB);
			Graphics2D g = bufImg.createGraphics();
			g.drawImage(srcImg, 0, 0, srcImgWidth, srcImgHeight, null);
			Font font = new Font("Courier New", Font.PLAIN, 18);
			// Font font = new Font(Font.SANS_SERIF, Font.PLAIN, 50);
			g.setColor(markContentColor); // 根据图片的背景设置水印颜色

			g.setFont(font);
			int x = srcImgWidth - getWatermarkLength(waterMarkContent, g) - 20;
			// int y = srcImgHeight - 3;
			int y = 30;
			// int x = (srcImgWidth - getWatermarkLength(watermarkStr, g)) / 2;
			// int y = srcImgHeight / 2;
			g.drawString(waterMarkContent, x, y);
			g.dispose();
			// 输出图片
			FileOutputStream outImgStream = new FileOutputStream(outImgPath);
			ImageIO.write(bufImg, "jpg", outImgStream);
			outImgStream.flush();
			outImgStream.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
    
	public static void mark(File srcFile, Color markContentColor, String dateStr, String dpetName, String sname) {
		try {
			if(srcFile==null){
				return ;
			}
			// 读取原图片信息
			File srcImgFile = srcFile;
			Image srcImg = ImageIO.read(srcImgFile);
			int srcImgWidth = srcImg.getWidth(null);
			int srcImgHeight = srcImg.getHeight(null);
			// 加水印
			BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, BufferedImage.TYPE_INT_RGB);
			Graphics2D g = bufImg.createGraphics();
			g.drawImage(srcImg, 0, 0, srcImgWidth, srcImgHeight, null);
			// 字体大小
			int n = srcImgWidth / 31;
			Font font = new Font("微软雅黑", Font.BOLD , n);
//			if(srcImgWidth<500){
//				n = srcImgWidth / 25;
//				font = new Font("微软雅黑", Font.BOLD , n);
//			}
			g.setColor(markContentColor); // 根据图片的背景设置水印颜色
			g.setFont(font);
//			FontRenderContext  frc = g.getFontRenderContext();
			int dateLength = 0; // 日期长度
			int watermarkHeight = srcImgHeight / 15; // 上边距
			int gapWidth = 20; // 左右边距
			// 添加日期水印
			if(StringUtils.isNotBlank(dateStr)){
				dateLength = getWatermarkLength(dateStr, g);
				int rightWidth = srcImgWidth - dateLength - gapWidth;
				g.drawString(dateStr, rightWidth, watermarkHeight);
			}
			String result="";
			// 添加门店/场景水印
			if(StringUtils.isNotBlank(dpetName)&&StringUtils.isNotBlank(sname)){
				result = dpetName+" - "+sname;
			} else if (StringUtils.isNotBlank(sname)) {
				result = sname;
			} else if (StringUtils.isNotBlank(dpetName)) {
				result = dpetName;
			}
			if (!"".equals(result)) {
				int maxOsLength = srcImgWidth - gapWidth * 2 - dateLength;
				int osLength = getWatermarkLength(result, g);
				// 超过长度，需要截取，考虑到后面的一般是关键信息，截断前面的字符
				if (osLength > maxOsLength) {
					int length = result.length() * maxOsLength / osLength;
					// 最终长度是length + 3(三个点)
					result = "..." + result.substring(result.length() - length, result.length());
				}
				g.drawString(result, gapWidth,watermarkHeight);
			}
			g.dispose();
			// 输出图片
			FileOutputStream outImgStream = new FileOutputStream(srcImgFile);
			ImageIO.write(bufImg, "jpg", outImgStream);
			outImgStream.flush();
			outImgStream.close();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	 public static String splitString(String str,int len) throws Exception {
         if (StringUtils.isBlank(str)) {
                return "";
         }     
         byte[] strByte = str.getBytes("UTF-8");
         int strLen =strByte.length;
         if (len >= strLen || len < 1) {
                return str;
          }     
         int count = 0;
         for (int i = 0; i < len; i++) {
                int value = (int) strByte[i];
                if (value < 0) {
             	   count++; 
                 } 
          }
          if (count % 2 != 0) {
                 len = len -1;
          }
         return new String(strByte, 0, len,"UTF-8");
   }
	/**
	 * 获取水印文字总长度
	 * 
	 * @param waterMarkContent
	 *            水印的文字
	 * @param g
	 * @return 水印文字总长度
	 */
	private static int getWatermarkLength(String waterMarkContent, Graphics2D g) {
		return g.getFontMetrics(g.getFont()).charsWidth(waterMarkContent.toCharArray(), 0, waterMarkContent.length());
	}
 

	private static int r(int min, int max) {
		int num = 0;
		num = random.nextInt(max - min) + min;
		return num;
	}

	public static BufferedImage createValidateCodePic(String id) throws IOException {
		// 在内存中创建一副图片
		int w = 120;
		int h = 50;
		BufferedImage img = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
		// 在图片上画一个矩形当背景
		Graphics g = img.getGraphics();
		g.setColor(new Color(r(50, 250), r(50, 250), r(50, 250)));
		g.fillRect(0, 0, w, h);

		String str = "aqzxswedcfrvgtbhyujklp23456789";
		StringBuffer code = new StringBuffer("");
		Graphics2D g2 = (Graphics2D) g;
		for (int i = 0; i < 4; i++) {
			g2.setStroke(new BasicStroke(3.0f));
			g2.setColor(new Color(r(50, 100), r(50, 100), r(50, 100)));
			g2.setFont(new Font("微软雅黑", Font.PLAIN, 40));
			char c = str.charAt(r(0, str.length()));
			g2.drawString(String.valueOf(c), 10 + i * 25, r(h - 30, h));
			
			code.append(c);
		}
		System.out.println("图片id: "+id);
		// 把code存入redis中
		//ValidateCodeRedisManager.putCode(id, code.toString());
		
		//redis数据库
		//CoCoRedisKit.set("validate_img_"+id, code.toString());
		
		//ehcache数据库
		CoCoEhCacheKit.put(SsoConst.VALIDATE_CACHE_NAME, SsoConst.VALIDATE_IMG_NAME+id, code.toString());
		
		// 画随机线
		g2.setStroke(new BasicStroke(5.0f));
		g2.setColor(new Color(r(50, 180), r(50, 180), r(50, 180)));
		g2.drawLine(7, 24, 110,22);
		for (int i = 0; i < 2; i++) {
			g2.setStroke(new BasicStroke(2.0f));
			g2.setColor(new Color(r(50, 180), r(50, 180), r(50, 180)));
			g2.drawLine(r(0, w), r(0, h), r(0, w), r(0, h));
		}
		// 把内存中创建的图像输出到文件中
		// File file = new File(PhotoPo.PIC_URL_ROOT + "validate/" +
		// "vcode.png");
		// ImageIO.write(img, "png", file);
		System.out.println("图片输出完成");
		return img;

	}
     public static void main(String[] args) throws Exception {
    	 //mark(new File("D:\\390.jpg"), Color.WHITE, "2017-10-18 17:44:44", "西树泡芙（南京金轮店）", "仪容仪表");
    	 createValidateCodePic("1");
	}
    
}
