package com.ovopark.open.common;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.Jedis;

public class RedisManager {
  
    public static void setRedisObj(String sessionId , Object obj) {
    	if(StringUtils.isNotBlank(sessionId) && obj!=null){
    		Jedis jedis =  null;
    		try{
    			jedis =  RedisPool.getJedis();
       		 	jedis.set( (obj.getClass().toString()+"_"+sessionId).getBytes(), SerializeUtil.serialize(obj));
    		}finally{
    			RedisPool.returnResource(jedis);
    		}
    	}
     }
    
    /**
     * 反序列化取对象, 用Jedis获取对象
     * 
     */
    public static Object getRedisObj(String sessionId , Class clz) {
    	if(StringUtils.isNotBlank(sessionId) && null!=clz){
    		Jedis jedis =  null;
    		Object obj = null;
    		try{
    			jedis =  RedisPool.getJedis();
       		 	byte[] data= jedis.get((clz.toString()+"_"+sessionId).getBytes());
	       		if (data != null && data.length > 0) {
	       			obj = SerializeUtil.unserialize(data);
	       		}
    		}finally{
    			RedisPool.returnResource(jedis);
    		}
            return obj;
    	}
    	return null;
    }
    
    /**
     * 从redis删除对象
     */
    public static void delRedisObj(String key) {
    	if(StringUtils.isNotBlank(key)){
    		Jedis jedis =  null;
    		try{
    			jedis =  RedisPool.getJedis();
    			jedis.del(key.getBytes());
    		}finally{
    			RedisPool.returnResource(jedis);
    		}
    	}
    }
    
    /**
     * 从redis删除对象
     */
    public static void delRedisObj(String sessionId , Class clz) {
    	if(StringUtils.isNotBlank(sessionId) && null!=clz){
    		Jedis jedis =  null;
    		try{
    			jedis =  RedisPool.getJedis();
    			jedis.del((clz.toString()+"_"+sessionId).getBytes());
    		}finally{
    			RedisPool.returnResource(jedis);
    		}
    	}
    }
    
    
    /**
     * 从redis删除对象,并返回被删除的对象
     */
    public static Object delRedisObjAndReturn(String sessionId , Class clz) {
    	if(StringUtils.isNotBlank(sessionId) && null!=clz){
    		Object result = null;
    		Jedis jedis =  null;
    		try{
    			jedis =  RedisPool.getJedis();
       		 	byte[] data= jedis.get((clz.toString()+"_"+sessionId).getBytes());
       		 	if (data != null && data.length > 0) {
	       		 	result = SerializeUtil.unserialize(data);
	       		 	jedis.del((clz.toString()+"_"+sessionId).getBytes());
       		 	}
    		}finally{
    			RedisPool.returnResource(jedis);
    		}
            return result;
    	}
    	return null;
    }
    
    
    
    public static Object getRedisObj(String key) {
    	if(StringUtils.isNotBlank(key) ){
    		Jedis jedis =  null;
    		Object obj = null;
    		try{
    			jedis =  RedisPool.getJedis();
       		 	byte[] data= jedis.get(key.getBytes());
	       		if (data != null && data.length > 0) {
	       			try{
	       			   obj = SerializeUtil.unserialize(data);
	       			}catch (Exception e) {
	        			delRedisObjByKey(key);
	        		}
	       		}
    		}finally{
    			RedisPool.returnResource(jedis);
    		}
            return obj;
    	}
    	return null;
    }
    public static void delRedisObjByKey(String key) {
    	if(StringUtils.isNotBlank(key)){
    		Jedis jedis =  null;
    		try{
    			jedis =  RedisPool.getJedis();
                jedis.del(key.getBytes());
    		}finally{
    			RedisPool.returnResource(jedis);
    		}
    	}
    }
    
    public  static void setExpxKeyCache(String k, String v, int time) {  
        Jedis jedis =  RedisPool.getJedis();
        try {  
            jedis.setex(k,time,v);  
        } catch (Exception e) {  
            e.printStackTrace(); 
            RedisPool.returnResource(jedis);
        } finally {  
        	RedisPool.returnResource(jedis);
        }  
    }  
	/**
	 * @Description:根据key返回值
	 * @param key
	 * @return:String
	 */
	public static String getValue(String key) {
		if (StringUtils.isNotBlank(key)) {
			Jedis jedis = RedisPool.getJedis();
			try {
				return jedis.get(key);
			} catch (Exception e) {
				e.printStackTrace();
				RedisPool.returnBrokenResource(jedis);
			} finally {
				RedisPool.returnResource(jedis);
			}
		}
		return null;
	}
	
	public static Set<String> keys(String pattern) {
		if (StringUtils.isNotBlank(pattern)) {
			Jedis jedis = RedisPool.getJedis();
			try {
				return jedis.keys(pattern);
			} catch (Exception e) {
				e.printStackTrace();
				RedisPool.returnBrokenResource(jedis);
			} finally {
				RedisPool.returnResource(jedis);
			}
		}
		return null;
	}
	
 }