package com.ovopark.open.common;

import java.util.ResourceBundle;

import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Transaction;

public final class RedisPool {
    
private static JedisPool jedisPool = null;
  
/**
 * 初始化Redis连接池
 */
static {
	try{
		ResourceBundle bundle = ResourceBundle.getBundle("system");  //读取配置文件redis.properties
		if (bundle == null) {
			throw new IllegalArgumentException("[system.properties] is not found!");
		}
		JedisPoolConfig config = new JedisPoolConfig();
		//config.setMaxActive(Integer.valueOf(bundle.getString("redis.pool.maxActive")));
		config.setMaxIdle(Integer.valueOf(bundle.getString("redis.pool.maxIdle")));
		config.setMaxTotal(Integer.valueOf(bundle.getString("redis.pool.maxTotal")));
		config.setMaxWaitMillis(Long.valueOf(bundle.getString("redis.pool.maxWait")));
		config.setTestOnBorrow(Boolean.valueOf(bundle.getString("redis.pool.testOnBorrow")));
		config.setTestOnReturn(Boolean.valueOf(bundle.getString("redis.pool.testOnReturn")));
		jedisPool = new JedisPool(config, bundle.getString("redis.ip"), Integer.valueOf(bundle.getString("redis.port")), Integer.valueOf(bundle.getString("redis.pool.timeOut")),  bundle.getString("redis.auth"));
	} catch (Exception e) {
        e.printStackTrace();
    }
	}

     
    /**
     * 获取Jedis实例
      * @return
     */
     //public synchronized static Jedis getJedis() {
	public static Jedis getJedis() {
		try {
			if (jedisPool != null) {
				Jedis resource = jedisPool.getResource();
				return resource;
			} else {
				return null;
			}
		} catch (Exception e) {
			e.printStackTrace();
			return null;
		}
	}
     /**
      * 获取事物
      * @return
      * @author huanglt
      */
     public static Transaction getTransactions() {
         try {
             if (jedisPool != null) {
                 Jedis resource = jedisPool.getResource();
                 Transaction tx = resource.multi();
                 return tx;
            } else {
                 return null;
             }
         } catch (Exception e) {
             e.printStackTrace();
            return null;
        }
     }
    
     /**
      * 释放jedis资源
      * @param jedis
      */
     public static void returnResource(final Jedis jedis) {
    	 if (jedis != null) {
    		 jedisPool.returnResource(jedis);
    	 }
     }
     public static void returnBrokenResource(final Jedis jedis) {
         if (jedis != null) {
             jedisPool.returnBrokenResource(jedis);
        }
     }
 }