package com.ovopark.open.common;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.ResourceBundle;

import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

import com.cloopen.rest.sdk.CCPRestSmsSDK;
/**
 * @author @Equaker
 */
public class SendSMS {
	

	private static Logger log = Logger.getLogger(SendSMS.class);
	private static MsgConfig config =null ;
	private static final ResourceBundle bundle ;
	private static SendSMS instance = null;
	static {
		 bundle = ResourceBundle.getBundle("system");
		 config = initConfig();
	}
    private static  MsgConfig initConfig() {  
	        try {  
	        	MsgConfig object = MsgConfig.class.newInstance();  
	            Class obj = object.getClass();  
	            Field[] fields = obj.getDeclaredFields();  
	            for (int i = 0; i < fields.length; i++) { 
	            	  fields[i].setAccessible(true); 
	            	  if(StringUtils.isNotBlank(bundle.getString(fields[i].getName()))){
	            		  fields[i].set(object,  bundle.getString(fields[i].getName()));  
	            	  }
	            }
	            return object;
	        }catch (Exception e) {
	    			log.error("Load  failed", e);
	    	}    
	        return null;
	           
	 }

	public static SendSMS getInstance() {
		if (instance == null)
			instance = new SendSMS();

		return instance;
	}
   /**
    * 发短信
    * @author huanglt
    */
	public String SendSms(String phone,String mId,String[] args){
		if(config==null){
			return "fail";
		}
		CCPRestSmsSDK restAPI = new CCPRestSmsSDK();
		restAPI.init(config.getSde(), config.getPort());
		//restAPI.init(config.getSpe(), config.getPort());
		restAPI.setAccount(config.getAccountId(), config.getToken());
		restAPI.setAppId(config.getAppId());
		HashMap<String, Object>  result = restAPI.sendTemplateSMS(phone,mId ,args);
		log.info("SDKTestGetSubAccounts result=" + result.get("statusCode"));
		return (String) result.get("statusCode");
	}
	public static void main(String[] args) {
		
		String[] msg = {"123456"};
		System.out.println(SendSMS.getInstance().SendSms("13347846025", "172724", msg));
	}

}
