package com.ovopark.open.common;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

import com.ovopark.cloud.core.kit.StrKit;




public class SsoUtils {
	
	public static int MINLENGTH_OF_SALT = 16; // 盐加密长度
	static final String DefaultAfterLoginAction = "gotodefault.sso";
	
	//获取随机票据
	public static String generateTicket(String cellphone, String password, String userIP, String salt) {
		StringBuffer ticket = new StringBuffer(SsoConst.TICKET_PREFIX);
		if (userIP == null)
			userIP = "";
		String nameSalt = new String(Hex.encodeHex(cellphone.getBytes())).toUpperCase();
		int sPos = (int) (Math.random() * 100) % MINLENGTH_OF_SALT;

		if (salt == null || salt.length() < MINLENGTH_OF_SALT) {
			salt = new String(
					Hex.encodeHex((cellphone + Base64.encodeBase64((salt + password).getBytes()) + salt).getBytes()))
							.toUpperCase();
			
		}

		String salt1 = salt.substring(sPos, sPos + sPos);
		String salt2 = salt.substring(sPos + sPos, MINLENGTH_OF_SALT + sPos);
		ticket.append(salt1);
		ticket.append(nameSalt);
		ticket.append(salt2);
		ticket.append(generateRandomString());
		return ticket.toString();
	}
	
	//获取公网Ip
	public static String getRemoteIP(HttpServletRequest request) {
		String ip = request.getHeader("x-forwarded-for");
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("WL-Proxy-Client-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("HTTP_CLIENT_IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("HTTP_X_FORWARDED_FOR");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getHeader("X-Real-IP");
		}
		if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
			ip = request.getRemoteAddr();
		}
		if (!StrKit.isBlank(ip)) {
			ip = ip.split(",")[0];
		}
		return ip;
	}
	
	private static String generateRandomString() {
		String rand = String.valueOf(Math.random());
		rand = rand.replace(".", "" + rand.charAt(rand.length() - 1));
		int length = (int) (Math.random() * 10);
		length = length < 5 ? 5 : length;
		return String.valueOf((new Random().nextInt(255) + rand)).substring(0, length);
	}
	
	public static String getCurrentDate(String format) {
		DateFormat df = new SimpleDateFormat(format);
		return df.format(new Date());
	}
    
	public static void setTicketToCookie(HttpServletRequest request, HttpServletResponse response, String ticket) {
		response.addCookie(new SsoCookie(SsoConst.KEY_OF_TICKET_COOKE, request.getContextPath(), ticket));
	}
	
}
