package com.ovopark.open.dao.impl;

import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

import com.ovopark.cloud.core.dao.CoCoDao;
import com.ovopark.cloud.core.dao.dynamic.CoCoDsCut;
import com.ovopark.cloud.core.db.plugin.mongodb.MongoDbService;
import com.ovopark.cloud.core.kit.DateKit;
import com.ovopark.cloud.core.kit.StrKit;
import com.ovopark.cloud.core.plugin.activerecord.MM;
import com.ovopark.cloud.core.plugin.activerecord.Page;
import com.ovopark.cloud.core.service.CoCoService;
import com.ovopark.cloud.core.utils.ToolSpring;
import com.ovopark.open.common.GenerateOpenKey;
import com.ovopark.open.dao.DeveloperDao;
import com.ovopark.open.domain.OpenEnterprise;
import com.ovopark.open.domain.OpenManger;

@Component("developerDao")
public class DeveloperDaoImpl implements DeveloperDao{
	
	static final  String aid="S107";
	
	static final  String status_yes="3";
	@Autowired
	private CoCoDao cocoDao;
	
	@Autowired
    private MongoDbService md;
	
	
	@Override
	public OpenEnterprise findEnterpriseByname(String enterprise_name) {
		

//		String sql1 = "select * from open_enterprise inner join open_manger "
//				    + "on open_enterprise.manger= open_enterprise.id "
//				    + "where enterprise_name=?";
		String sql = "select * from open_enterprise where enterprise_name=?";
		
		List<OpenEnterprise> enterprises = cocoDao.query(sql, OpenEnterprise.class, enterprise_name);
		//MM mms = cocoDao.findFirstMM(sql,enterprise_name);
		if(enterprises!=null&&enterprises.size()>0) {
			return enterprises.get(0);
		}
		return null;
		//return mms;
	}

	@Override
	public void addEnterprise(OpenEnterprise openEnterprise) {
		openEnterprise.setCreate_time(new Date());
		cocoDao.save("open_enterprise", openEnterprise);
		
	}

	@Override
	public void addManger(OpenManger openManger) {
		cocoDao.save("open_manger", openManger);
		
	}

	@Override
	public List<String> findFirstIndusty() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<String> findSecondIndustyByid(Integer id) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public OpenManger findMangerBynameandphone(String name, String cellphone) {
		
		String sql = "select * from open_manger where manger_name=? and manger_cellphone1=?";
		
		List<OpenManger> openMangers = cocoDao.query(sql, OpenManger.class, name,cellphone);
		if(openMangers!=null&&openMangers.size()>0) {
			return openMangers.get(0);
		}
		return null;
	}

	@Override
	public OpenManger findmangerByphone(String cellphone) {
		String sql = "select * from open_manger where and manger_cellphone1=?";
		
		List<OpenManger> openMangers = cocoDao.query(sql, OpenManger.class,cellphone);
		if(openMangers!=null&&openMangers.size()>0) {
			return openMangers.get(0);
		}

		return null;
	}

	@Override
	public OpenEnterprise findEnterpriseByphone(String cellphone) {
        
		String sql = "select * from open_enterprise where developer_cellphone=?";
		
		List<OpenEnterprise> enterprises = cocoDao.query(sql, OpenEnterprise.class, cellphone);
		//MM mms = cocoDao.findFirstMM(sql,enterprise_name);
		if(enterprises!=null&&enterprises.size()>0) {
			return enterprises.get(0);
		}
		return null;
	}

	@Override
	public void updateEnterprise(OpenEnterprise openEnterprise) {
		openEnterprise.setStatus("1");
		openEnterprise.setUpdate_time(new Date());
		cocoDao.updatePoJo("open_enterprise", openEnterprise);
		
	}

	@Override
	public OpenEnterprise getEnterPriseByusercode(String admin_usercode) {
		
		String sql = "select * from open_enterprise where admin_usercode=?";
		
		List<OpenEnterprise> enterprises = cocoDao.query(sql, OpenEnterprise.class, admin_usercode);
		//MM mms = cocoDao.findFirstMM(sql,enterprise_name);
		
		if(enterprises!=null&&enterprises.size()>0) {
			return enterprises.get(0);
		}

		return null;
	}

	@Transactional(isolation=Isolation.SERIALIZABLE)
	//2：审核不通过;3：审核通过
	public void examineEnterPrise(String status,Long id) {
		OpenEnterprise open=cocoDao.findObjById("open_enterprise", id, OpenEnterprise.class);
		if(open!=null){
			open.setExamine_time(new Date());
			open.setStatus(status);
			cocoDao.updatePoJo("open_enterprise", open);
			//审核通过分配密匙密钥
			if(status_yes.equals(status)){
				Long if_exist=cocoDao.queryLong("select count(1) from open_auth_user where enterprise_id=?",open.getId());
				if(if_exist==0){
					String max_application_key=cocoDao.queryStr("select max(application_key) from open_auth_user");
					GenerateOpenKey gtopen=GenerateOpenKey.create();
					String application_key=gtopen.generaterOpenKey(max_application_key);
					String application_secret=gtopen.generaterOpenSecret(application_key);
					MM mm=new MM();
					mm.put("username", open.getEnterprise_name());
					mm.put("enterprise_id", open.getId());
					mm.put("application_id", aid);
					mm.put("application_key", application_key);
					mm.put("application_secret", application_secret);
					cocoDao.save("open_auth_user", mm);
					MM mongodbMM=new MM();
					mongodbMM.put("open_auth_id", mm.get("id"));
					mongodbMM.put("enterprise_id", open.getId());
					mongodbMM.put("ifexpire", 3);
					mongodbMM.put("application_id", aid);
					mongodbMM.put("application_key", application_key);
					mongodbMM.put("application_secret", application_secret);
					md.save("open_auth_user", mongodbMM);
				}
	
			}

		}
		
	}

	@Override
	public void switchAuth(String status,Long id) {
		Date date=new Date();
		cocoDao.update("update open_auth_user set switch_time=?,switch_status=? where  enterprise_id=?",date,status,id);
		Criteria criteria= Criteria.where("enterprise_id").is(id);
		Query query=new Query(criteria);
		Update update = new Update();
		update.set("switch_status", status);
		String switch_time=DateKit.DateTime2Str(date, DateKit.getTimeFormat());
		update.set("switch_time",switch_time);
		md.updateFirst(query, update, "open_auth_user");
	}

	@Override
	public Page<MM> getEnterPriseByStatus(String status, Integer pageNo, Integer pageSize) {
		StringBuffer sf=new StringBuffer();
		sf.append("select id,enterprise_name,create_time,status from open_enterprise  where 1=1 ");
		if(!StrKit.isBlank(status))
			sf.append(" and status='").append(status).append("'");
		 Page<MM> page=cocoDao.paginate(sf.toString(), pageNo, pageSize);
		return page;
	}

	@Override
	public List<MM> searchEnterprise(String enterprise_name) {
		//切换成shopweb数据源
		CoCoDsCut.setDataSourceType("ds2");
		StringBuffer sf=new StringBuffer();
		sf.append("select id ,name from is_enterprise_groups where 1=1");
		if(!StrKit.isBlank(enterprise_name))
			sf.append(" and name like '%").append(enterprise_name).append("%'");
		List<MM> list=cocoDao.findManyMM(sf.toString());
		CoCoDsCut.setDataSourceType("ds1");
		return list;
	}

	@Override
	public void relateEnterprise(Long open_enterprise_id, Long shopweb_enterprise_id) {
		cocoDao.update("update open_auth_user set shopweb_enterprise_id=? where enterprise_id=?",shopweb_enterprise_id,open_enterprise_id);
		Criteria criteria= Criteria.where("enterprise_id").is(open_enterprise_id);
		Query query=new Query(criteria);
		Update update = new Update();
		update.set("shopweb_enterprise_id",shopweb_enterprise_id);
		md.updateFirst(query, update, "open_auth_user");
	}

	@Override
	public OpenEnterprise getEnterPriseById(Long id) {
		OpenEnterprise openEnterprise=cocoDao.findObjById("open_enterprise", id, OpenEnterprise.class);
		return openEnterprise;
	}

	@Override
	public String getSwitchStatus( Long id) {
		String switch_status=cocoDao.queryStr("select switch_status from open_auth_user where enterprise_id=?",id);
		return switch_status;
	}

	@Override
	public MM getSwitchEnterprise(Long id) {
		Long shopweb_enterprise_id=cocoDao.queryLong("select shopweb_enterprise_id from open_auth_user where enterprise_id=?",id);
		if(shopweb_enterprise_id==null)
			return null;
		//切换成shopweb数据源
		CoCoDsCut.setDataSourceType("ds2");
		MM mm=cocoDao.findFirstMM("select id ,name from is_enterprise_groups where id=?",shopweb_enterprise_id);
		CoCoDsCut.setDataSourceType("ds1");
		return mm;
	}

}
