package com.ovopark.open.dao.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.ovopark.cloud.core.dao.CoCoDao;
import com.ovopark.cloud.core.kit.StrKit;
import com.ovopark.cloud.core.kit.TreeKit;
import com.ovopark.cloud.core.plugin.activerecord.MM;
import com.ovopark.open.dao.SystemDao;
@Repository
public class SystemDaoImpl implements SystemDao{
	final static String default_systemid="s107";
	@Autowired  CoCoDao cocoDao;
	@Override
	public List<MM> queryDict(String type, String systemid) {
		systemid=StrKit.isBlank(systemid)?default_systemid:systemid;
		StringBuffer sb=new StringBuffer();
		sb.append(" select id,dname as text,value,fatherid as pid from sys_dict ");
		sb.append(" where systemid=?");
		if(!StrKit.isBlank(type)){
			sb.append(" and type='").append(type).append("' ");
		}
		sb.append(" order by sort ");
		List<MM> list=cocoDao.findManyMM(sb.toString(),systemid);
		List<MM> tree=ArrayToTreeData(list, "id", "pid");
		return tree;
	}
	public static List<MM> ArrayToTreeData(List<MM> mydata, String id, String pid) {
		Map<Object, Object> h = new HashMap<Object, Object>();// 数据索引
		List<MM> r = new ArrayList<MM>();// 数据池，返回的数据

		for (MM item : mydata) {
			if (!item.containsKey(id)) {
				continue;
			} else {
				h.put(item.get(id), item);
			}
		}
		for (MM item : mydata) {
			if (!item.containsKey(id)) {
				continue;
			}
			if (!item.containsKey(pid) || (item.get(pid) == null) || !h.containsKey(item.get(pid))) {
				r.add(item);
			} else {
				Map<String, List<MM>> pitem = (Map<String, List<MM>>) h.get(item.get(pid));
				if (!pitem.containsKey("children")) {
					List<MM> children = new ArrayList<MM>();
					children.add(item);
					pitem.put("children", children);
				} else {
					List<MM> children = pitem.get("children");
					children.add(item);
					pitem.put("children", children);
				}
			}
		}
		for (MM mm : r) {
			if(mm.containsKey("children")&&mm.getLong("pid")==0){
				List<MM> list=(List<MM>)mm.get("children");
				for (MM mm2 : list) {
					if(!mm2.containsKey("children")){
						mm2.put("children", new ArrayList<MM>());
					}
				}
			}
		}
		return r;
	}
	@Override
	public void apply(Long enterprise_id) {
		
	}

}
