package com.ovopark.open.dao.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.ovopark.cloud.core.dao.CoCoDao;
import com.ovopark.cloud.core.plugin.activerecord.MM;
import com.ovopark.open.dao.UserDao;
import com.ovopark.open.domain.OpenUser;

@Component("userDao")
public class UserDaoImpl implements UserDao{

	@Autowired
	private CoCoDao cocoDao;
	
	@Override
	public void user_Register(OpenUser user) {
		
		cocoDao.save("open_account", user);
		
	}	

	@Override
	public OpenUser findUserByPhone(String phoneNumber) {
		
		String sql = "select * from open_account where cellphone="+phoneNumber;
		List<OpenUser> users = cocoDao.query(sql, OpenUser.class);
		
		if(users != null && users.size()>0) {
			return users.get(0);
		}
		
		return null;
	}
	
	@Override
	public void update(OpenUser newUser) {
		
		cocoDao.updatePoJo("open_account", newUser);
		//cocoDao.update(sql, paras)
		
		
	}

	@Override
	public OpenUser findUserByPhoneOrUserName(String phoneOrName) {
		
		//String sql = "select * from open_account where username='"+phoneOrName+"' or cellphone='"+phoneOrName+"'";
		String sql = "select * from open_account where cellphone=? or username=?";
		//List<OpenUser> users = cocoDao.query(sql, OpenUser.class);
		List<OpenUser> users = cocoDao.query(sql, OpenUser.class, phoneOrName,phoneOrName);
		if(users != null && users.size()>0) {
			return users.get(0);
		}
		
		return null;
	}

}
