package com.ovopark.open.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ovopark.cloud.core.plugin.activerecord.MM;
import com.ovopark.cloud.core.plugin.activerecord.Page;
import com.ovopark.open.api.rpc.DeveloperApi;
import com.ovopark.open.dao.DeveloperDao;
import com.ovopark.open.domain.OpenEnterprise;
import com.ovopark.open.domain.OpenManger;
@Service("developerApi")
public class DeveloperServiceImpl implements DeveloperApi{

	@Autowired
	private DeveloperDao developerDao;
	
	@Override
	public OpenEnterprise findEnterpriseByname(String enterprise_name) {
		
		OpenEnterprise newEnterprise = developerDao.findEnterpriseByname(enterprise_name);
		if(newEnterprise != null) {
			return newEnterprise;
		}
		return null;
	}

	@Override
	public void addEnterprise(OpenEnterprise openEnterprise) {
		developerDao.addEnterprise(openEnterprise);
		
	}

	@Override
	public void addManger(OpenManger openManger) {
		developerDao.addManger(openManger);
		
	}

	@Override
	public List<String> findFirstIndusty() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<String> findSecondIndustyByid(Integer id) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public OpenManger findMangerBynameandphone(String name, String cellphone) {
		
		return developerDao.findMangerBynameandphone(name, cellphone);
	}

	@Override
	public OpenManger findmangerByphone(String cellphone) {
		
		return developerDao.findmangerByphone(cellphone);
	}

	@Override
	public OpenEnterprise findEnterpriseByphone(String cellphone) {
		
		return developerDao.findEnterpriseByphone(cellphone);
	}

	@Override
	public void updateEnterprise(OpenEnterprise openEnterprise) {
		developerDao.updateEnterprise(openEnterprise);
	}

	@Override
	public OpenEnterprise getEnterPriseByusercode(String admin_usercode) {
		
		return developerDao.getEnterPriseByusercode(admin_usercode);
	}

	@Override
	public void examineEnterPrise(String status,Long id) {
		developerDao.examineEnterPrise(status,id);
	}

	@Override
	public void switchAuth(String status,Long id) {
		developerDao.switchAuth(status,id);
	}

	@Override
	public Page<MM> getEnterPriseByStatus(String status,Integer pageNo,Integer pageSize) {
		return developerDao.getEnterPriseByStatus(status, pageNo, pageSize);
	}

	@Override
	public List<MM> searchEnterprise(String enterprise_name) {
		return developerDao.searchEnterprise(enterprise_name);
	}

	@Override
	public void relateEnterprise(Long open_enterprise_id, Long shopweb_enterprise_id) {
		developerDao.relateEnterprise(open_enterprise_id, shopweb_enterprise_id);
	}

	@Override
	public OpenEnterprise getEnterPriseById(Long id) {
		return developerDao.getEnterPriseById(id);
	}

	@Override
	public String getSwitchStatus( Long id) {
		return developerDao.getSwitchStatus( id);
	}

	@Override
	public MM getSwitchEnterprise(Long id) {
		return developerDao.getSwitchEnterprise(id);
	} 
	
}
