package com.ovopark.open.service.impl;


import java.util.Date;



import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ovopark.cloud.cache.ehCache.CoCoEhCacheKit;
import com.ovopark.cloud.core.dao.CoCoDao;
import com.ovopark.open.api.rpc.UserService;
import com.ovopark.open.common.SsoConst;
import com.ovopark.open.dao.UserDao;
import com.ovopark.open.domain.OpenUser;


@Service("userService")
public class UserServiceimpl implements UserService{

	@Autowired
	private UserDao userDao;
	
	
	@Override
	public void user_add(OpenUser user) {
		
		//usercode 默认是手机号
		if(user.getUsercode()==null || "".equals(user.getUsercode())) {
			user.setUsercode(user.getCellphone());
		}
		user.setCreate_time(new Date());
		
		//数据库保存的信息验证码
		//String code = ValidateCodeRedisManager.getCode(user.getCellphone());		
				
		//正常注册,删除验证码
		userDao.user_Register(user);
		CoCoEhCacheKit.remove(SsoConst.VALIDATE_CACHE_NAME, "validate_phone_"+user.getCellphone());
		
		
		
	}

	@Override
	public OpenUser findUserByPhone(String phoneNumber) {
		// TODO Auto-generated method stub
		return userDao.findUserByPhone(phoneNumber);
	}

	@Override
	public void update(OpenUser newUser) {
		userDao.update(newUser);
		
	}

	@Override
	public OpenUser findUserByPhoneOrUserName(String phoneOrName) {
					
		return userDao.findUserByPhoneOrUserName(phoneOrName);
	}

	

}
