/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.open.common;

import com.ovopark.cloud.core.kit.StrKit;
import com.ovopark.open.common.Md5Util;
import java.text.DecimalFormat;
import java.util.UUID;

public class GenerateOpenKey {
    private static final String firstKey = "S107-00000001";
    private static final String aid = "S107";
    private static final String line = "-";
    static final String SALT_1 = "{ovopark:open->}";
    static final String SALT_2 = "{<-ovopark:open}";

    public static GenerateOpenKey create() {
        return OpenKey.instance.init();
    }

    public String generaterOpenKey(String maxKey) {
        String prefix = "S107-";
        String nextKey = "";
        if (StrKit.isBlank((String)maxKey)) {
            nextKey = firstKey;
        } else {
            DecimalFormat df = new DecimalFormat("00000000");
            nextKey = prefix + df.format(1 + Integer.parseInt(maxKey.substring(prefix.length(), maxKey.length())));
        }
        return nextKey;
    }

    public String generaterOpenSecret(String akey) {
        String guid = this.guid();
        String key = SALT_1 + akey + guid + SALT_2;
        String asid = Md5Util.computeToHex(key.getBytes());
        return asid;
    }

    private String guid() {
        UUID uuid = UUID.randomUUID();
        String key = uuid.toString();
        return key;
    }

    public static void main(String[] args) {
        String key = GenerateOpenKey.create().generaterOpenKey("S107-15433213");
        System.out.println(key);
    }

    private static enum OpenKey {
        instance;

        private GenerateOpenKey openkey = new GenerateOpenKey();

        private GenerateOpenKey init() {
            return this.openkey;
        }
    }
}

