/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.open.common;

import com.ovopark.cloud.cache.ehCache.CoCoEhCacheKit;
import com.ovopark.open.common.SsoConst;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.StringUtils;

public class ImageUtils {
    public static Random random = new Random();

    public static void mark(String srcImgPath, String outImgPath, Color markContentColor, String waterMarkContent) {
        try {
            File srcImgFile = new File(srcImgPath);
            BufferedImage srcImg = ImageIO.read(srcImgFile);
            int srcImgWidth = ((Image)srcImg).getWidth(null);
            int srcImgHeight = ((Image)srcImg).getHeight(null);
            BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
            Graphics2D g = bufImg.createGraphics();
            g.drawImage(srcImg, 0, 0, srcImgWidth, srcImgHeight, null);
            Font font = new Font("Courier New", 0, 18);
            g.setColor(markContentColor);
            g.setFont(font);
            int x = srcImgWidth - ImageUtils.getWatermarkLength(waterMarkContent, g) - 20;
            int y = 30;
            g.drawString(waterMarkContent, x, y);
            g.dispose();
            FileOutputStream outImgStream = new FileOutputStream(outImgPath);
            ImageIO.write((RenderedImage)bufImg, "jpg", outImgStream);
            outImgStream.flush();
            outImgStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mark(File srcFile, Color markContentColor, String dateStr, String dpetName, String sname) {
        try {
            if (srcFile == null) {
                return;
            }
            File srcImgFile = srcFile;
            BufferedImage srcImg = ImageIO.read(srcImgFile);
            int srcImgWidth = ((Image)srcImg).getWidth(null);
            int srcImgHeight = ((Image)srcImg).getHeight(null);
            BufferedImage bufImg = new BufferedImage(srcImgWidth, srcImgHeight, 1);
            Graphics2D g = bufImg.createGraphics();
            g.drawImage(srcImg, 0, 0, srcImgWidth, srcImgHeight, null);
            int n = srcImgWidth / 31;
            Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, n);
            g.setColor(markContentColor);
            g.setFont(font);
            int dateLength = 0;
            int watermarkHeight = srcImgHeight / 15;
            int gapWidth = 20;
            if (StringUtils.isNotBlank((CharSequence)dateStr)) {
                dateLength = ImageUtils.getWatermarkLength(dateStr, g);
                int rightWidth = srcImgWidth - dateLength - gapWidth;
                g.drawString(dateStr, rightWidth, watermarkHeight);
            }
            String result = "";
            if (StringUtils.isNotBlank((CharSequence)dpetName) && StringUtils.isNotBlank((CharSequence)sname)) {
                result = dpetName + " - " + sname;
            } else if (StringUtils.isNotBlank((CharSequence)sname)) {
                result = sname;
            } else if (StringUtils.isNotBlank((CharSequence)dpetName)) {
                result = dpetName;
            }
            if (!"".equals(result)) {
                int maxOsLength = srcImgWidth - gapWidth * 2 - dateLength;
                int osLength = ImageUtils.getWatermarkLength(result, g);
                if (osLength > maxOsLength) {
                    int length = result.length() * maxOsLength / osLength;
                    result = "..." + result.substring(result.length() - length, result.length());
                }
                g.drawString(result, gapWidth, watermarkHeight);
            }
            g.dispose();
            FileOutputStream outImgStream = new FileOutputStream(srcImgFile);
            ImageIO.write((RenderedImage)bufImg, "jpg", outImgStream);
            outImgStream.flush();
            outImgStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String splitString(String str, int len) throws Exception {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        byte[] strByte = str.getBytes("UTF-8");
        int strLen = strByte.length;
        if (len >= strLen || len < 1) {
            return str;
        }
        int count = 0;
        for (int i = 0; i < len; ++i) {
            byte value = strByte[i];
            if (value >= 0) continue;
            ++count;
        }
        if (count % 2 != 0) {
            --len;
        }
        return new String(strByte, 0, len, "UTF-8");
    }

    private static int getWatermarkLength(String waterMarkContent, Graphics2D g) {
        return g.getFontMetrics(g.getFont()).charsWidth(waterMarkContent.toCharArray(), 0, waterMarkContent.length());
    }

    private static int r(int min, int max) {
        int num = 0;
        num = random.nextInt(max - min) + min;
        return num;
    }

    public static BufferedImage createValidateCodePic(String id) throws IOException {
        int i;
        int w = 120;
        int h = 50;
        BufferedImage img = new BufferedImage(w, h, 1);
        Graphics g = img.getGraphics();
        g.setColor(new Color(ImageUtils.r(50, 250), ImageUtils.r(50, 250), ImageUtils.r(50, 250)));
        g.fillRect(0, 0, w, h);
        String str = "aqzxswedcfrvgtbhyujklp23456789";
        StringBuffer code = new StringBuffer("");
        Graphics2D g2 = (Graphics2D)g;
        for (i = 0; i < 4; ++i) {
            g2.setStroke(new BasicStroke(3.0f));
            g2.setColor(new Color(ImageUtils.r(50, 100), ImageUtils.r(50, 100), ImageUtils.r(50, 100)));
            g2.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 40));
            char c = str.charAt(ImageUtils.r(0, str.length()));
            g2.drawString(String.valueOf(c), 10 + i * 25, ImageUtils.r(h - 30, h));
            code.append(c);
        }
        System.out.println("\u56fe\u7247id: " + id);
        CoCoEhCacheKit.put((String)SsoConst.VALIDATE_CACHE_NAME, (Object)("validate_img_" + id), (Object)code.toString());
        g2.setStroke(new BasicStroke(5.0f));
        g2.setColor(new Color(ImageUtils.r(50, 180), ImageUtils.r(50, 180), ImageUtils.r(50, 180)));
        g2.drawLine(7, 24, 110, 22);
        for (i = 0; i < 2; ++i) {
            g2.setStroke(new BasicStroke(2.0f));
            g2.setColor(new Color(ImageUtils.r(50, 180), ImageUtils.r(50, 180), ImageUtils.r(50, 180)));
            g2.drawLine(ImageUtils.r(0, w), ImageUtils.r(0, h), ImageUtils.r(0, w), ImageUtils.r(0, h));
        }
        System.out.println("\u56fe\u7247\u8f93\u51fa\u5b8c\u6210");
        return img;
    }

    public static void main(String[] args) throws Exception {
        ImageUtils.createValidateCodePic("1");
    }
}

