/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.open.common;

import com.ovopark.open.common.RedisPool;
import com.ovopark.open.common.SerializeUtil;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import redis.clients.jedis.Jedis;

public class RedisManager {
    public static void setRedisObj(String sessionId, Object obj) {
        if (StringUtils.isNotBlank((CharSequence)sessionId) && obj != null) {
            Jedis jedis = null;
            try {
                jedis = RedisPool.getJedis();
                jedis.set((obj.getClass().toString() + "_" + sessionId).getBytes(), SerializeUtil.serialize(obj));
            }
            finally {
                RedisPool.returnResource(jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getRedisObj(String sessionId, Class clz) {
        if (StringUtils.isNotBlank((CharSequence)sessionId) && null != clz) {
            Jedis jedis = null;
            Object obj = null;
            try {
                jedis = RedisPool.getJedis();
                byte[] data = jedis.get((clz.toString() + "_" + sessionId).getBytes());
                if (data != null && data.length > 0) {
                    obj = SerializeUtil.unserialize(data);
                }
            }
            finally {
                RedisPool.returnResource(jedis);
            }
            return obj;
        }
        return null;
    }

    public static void delRedisObj(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            Jedis jedis = null;
            try {
                jedis = RedisPool.getJedis();
                jedis.del(key.getBytes());
            }
            finally {
                RedisPool.returnResource(jedis);
            }
        }
    }

    public static void delRedisObj(String sessionId, Class clz) {
        if (StringUtils.isNotBlank((CharSequence)sessionId) && null != clz) {
            Jedis jedis = null;
            try {
                jedis = RedisPool.getJedis();
                jedis.del((clz.toString() + "_" + sessionId).getBytes());
            }
            finally {
                RedisPool.returnResource(jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object delRedisObjAndReturn(String sessionId, Class clz) {
        if (StringUtils.isNotBlank((CharSequence)sessionId) && null != clz) {
            Object result = null;
            Jedis jedis = null;
            try {
                jedis = RedisPool.getJedis();
                byte[] data = jedis.get((clz.toString() + "_" + sessionId).getBytes());
                if (data != null && data.length > 0) {
                    result = SerializeUtil.unserialize(data);
                    jedis.del((clz.toString() + "_" + sessionId).getBytes());
                }
            }
            finally {
                RedisPool.returnResource(jedis);
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getRedisObj(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            Jedis jedis = null;
            Object obj = null;
            try {
                jedis = RedisPool.getJedis();
                byte[] data = jedis.get(key.getBytes());
                if (data != null && data.length > 0) {
                    try {
                        obj = SerializeUtil.unserialize(data);
                    }
                    catch (Exception e) {
                        RedisManager.delRedisObjByKey(key);
                    }
                }
            }
            finally {
                RedisPool.returnResource(jedis);
            }
            return obj;
        }
        return null;
    }

    public static void delRedisObjByKey(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            Jedis jedis = null;
            try {
                jedis = RedisPool.getJedis();
                jedis.del(key.getBytes());
            }
            finally {
                RedisPool.returnResource(jedis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setExpxKeyCache(String k, String v, int time) {
        Jedis jedis = RedisPool.getJedis();
        try {
            jedis.setex(k, time, v);
        }
        catch (Exception e) {
            e.printStackTrace();
            RedisPool.returnResource(jedis);
        }
        finally {
            RedisPool.returnResource(jedis);
        }
    }

    public static String getValue(String key) {
        if (StringUtils.isNotBlank((CharSequence)key)) {
            Jedis jedis = RedisPool.getJedis();
            try {
                String string = jedis.get(key);
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                RedisPool.returnBrokenResource(jedis);
            }
            finally {
                RedisPool.returnResource(jedis);
            }
        }
        return null;
    }

    public static Set<String> keys(String pattern) {
        if (StringUtils.isNotBlank((CharSequence)pattern)) {
            Jedis jedis = RedisPool.getJedis();
            try {
                Set set = jedis.keys(pattern);
                return set;
            }
            catch (Exception e) {
                e.printStackTrace();
                RedisPool.returnBrokenResource(jedis);
            }
            finally {
                RedisPool.returnResource(jedis);
            }
        }
        return null;
    }
}

