/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.open.common;

import java.util.ResourceBundle;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Transaction;

public final class RedisPool {
    private static JedisPool jedisPool = null;

    public static Jedis getJedis() {
        try {
            if (jedisPool != null) {
                Jedis resource = jedisPool.getResource();
                return resource;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Transaction getTransactions() {
        try {
            if (jedisPool != null) {
                Jedis resource = jedisPool.getResource();
                Transaction tx = resource.multi();
                return tx;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void returnResource(Jedis jedis) {
        if (jedis != null) {
            jedisPool.returnResource(jedis);
        }
    }

    public static void returnBrokenResource(Jedis jedis) {
        if (jedis != null) {
            jedisPool.returnBrokenResource(jedis);
        }
    }

    static {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle("system");
            if (bundle == null) {
                throw new IllegalArgumentException("[system.properties] is not found!");
            }
            JedisPoolConfig config = new JedisPoolConfig();
            config.setMaxIdle(Integer.valueOf(bundle.getString("redis.pool.maxIdle")).intValue());
            config.setMaxTotal(Integer.valueOf(bundle.getString("redis.pool.maxTotal")).intValue());
            config.setMaxWaitMillis(Long.valueOf(bundle.getString("redis.pool.maxWait")).longValue());
            config.setTestOnBorrow(Boolean.valueOf(bundle.getString("redis.pool.testOnBorrow")).booleanValue());
            config.setTestOnReturn(Boolean.valueOf(bundle.getString("redis.pool.testOnReturn")).booleanValue());
            jedisPool = new JedisPool((GenericObjectPoolConfig)config, bundle.getString("redis.ip"), Integer.valueOf(bundle.getString("redis.port")).intValue(), Integer.valueOf(bundle.getString("redis.pool.timeOut")).intValue(), bundle.getString("redis.auth"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

