/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.open.common;

import com.ovopark.cloud.core.kit.StrKit;
import com.ovopark.open.common.SsoCookie;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class SsoUtils {
    public static int MINLENGTH_OF_SALT = 16;
    static final String DefaultAfterLoginAction = "gotodefault.sso";

    public static String generateTicket(String cellphone, String password, String userIP, String salt) {
        StringBuffer ticket = new StringBuffer("tk_");
        if (userIP == null) {
            userIP = "";
        }
        String nameSalt = new String(Hex.encodeHex((byte[])cellphone.getBytes())).toUpperCase();
        int sPos = (int)(Math.random() * 100.0) % MINLENGTH_OF_SALT;
        if (salt == null || salt.length() < MINLENGTH_OF_SALT) {
            salt = new String(Hex.encodeHex((byte[])(cellphone + Base64.encodeBase64((byte[])(salt + password).getBytes()) + salt).getBytes())).toUpperCase();
        }
        String salt1 = salt.substring(sPos, sPos + sPos);
        String salt2 = salt.substring(sPos + sPos, MINLENGTH_OF_SALT + sPos);
        ticket.append(salt1);
        ticket.append(nameSalt);
        ticket.append(salt2);
        ticket.append(SsoUtils.generateRandomString());
        return ticket.toString();
    }

    public static String getRemoteIP(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (!StrKit.isBlank((String)ip)) {
            ip = ip.split(",")[0];
        }
        return ip;
    }

    private static String generateRandomString() {
        String rand = String.valueOf(Math.random());
        rand = rand.replace(".", "" + rand.charAt(rand.length() - 1));
        int length = (int)(Math.random() * 10.0);
        length = length < 5 ? 5 : length;
        return String.valueOf(new Random().nextInt(255) + rand).substring(0, length);
    }

    public static String getCurrentDate(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(new Date());
    }

    public static void setTicketToCookie(HttpServletRequest request, HttpServletResponse response, String ticket) {
        response.addCookie((Cookie)new SsoCookie("cocosso_tk_ck", request.getContextPath(), ticket));
    }
}

