/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.open.dao.impl;

import com.ovopark.cloud.core.dao.CoCoDao;
import com.ovopark.cloud.core.dao.dynamic.CoCoDsCut;
import com.ovopark.cloud.core.db.plugin.mongodb.MongoDbService;
import com.ovopark.cloud.core.kit.DateKit;
import com.ovopark.cloud.core.kit.StrKit;
import com.ovopark.cloud.core.plugin.activerecord.MM;
import com.ovopark.cloud.core.plugin.activerecord.Page;
import com.ovopark.open.common.GenerateOpenKey;
import com.ovopark.open.dao.DeveloperDao;
import com.ovopark.open.domain.OpenEnterprise;
import com.ovopark.open.domain.OpenManger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Component(value="developerDao")
public class DeveloperDaoImpl
implements DeveloperDao {
    static final String aid = "S107";
    static final String status_yes = "3";
    @Autowired
    private CoCoDao cocoDao;
    @Autowired
    private MongoDbService md;

    @Override
    public OpenEnterprise findEnterpriseByname(String enterprise_name) {
        String sql = "select * from open_enterprise where enterprise_name=?";
        List enterprises = this.cocoDao.query(sql, OpenEnterprise.class, new Object[]{enterprise_name});
        if (enterprises != null && enterprises.size() > 0) {
            return (OpenEnterprise)enterprises.get(0);
        }
        return null;
    }

    @Override
    public void addEnterprise(OpenEnterprise openEnterprise) {
        openEnterprise.setCreate_time(new Date());
        this.cocoDao.save("open_enterprise", (Object)openEnterprise);
    }

    @Override
    public void addManger(OpenManger openManger) {
        this.cocoDao.save("open_manger", (Object)openManger);
    }

    @Override
    public List<String> findFirstIndusty() {
        return null;
    }

    @Override
    public List<String> findSecondIndustyByid(Integer id) {
        return null;
    }

    @Override
    public OpenManger findMangerBynameandphone(String name, String cellphone) {
        String sql = "select * from open_manger where manger_name=? and manger_cellphone1=?";
        List openMangers = this.cocoDao.query(sql, OpenManger.class, new Object[]{name, cellphone});
        if (openMangers != null && openMangers.size() > 0) {
            return (OpenManger)openMangers.get(0);
        }
        return null;
    }

    @Override
    public OpenManger findmangerByphone(String cellphone) {
        String sql = "select * from open_manger where and manger_cellphone1=?";
        List openMangers = this.cocoDao.query(sql, OpenManger.class, new Object[]{cellphone});
        if (openMangers != null && openMangers.size() > 0) {
            return (OpenManger)openMangers.get(0);
        }
        return null;
    }

    @Override
    public OpenEnterprise findEnterpriseByphone(String cellphone) {
        String sql = "select * from open_enterprise where developer_cellphone=?";
        List enterprises = this.cocoDao.query(sql, OpenEnterprise.class, new Object[]{cellphone});
        if (enterprises != null && enterprises.size() > 0) {
            return (OpenEnterprise)enterprises.get(0);
        }
        return null;
    }

    @Override
    public void updateEnterprise(OpenEnterprise openEnterprise) {
        openEnterprise.setStatus("1");
        openEnterprise.setUpdate_time(new Date());
        this.cocoDao.updatePoJo("open_enterprise", (Object)openEnterprise);
    }

    @Override
    public OpenEnterprise getEnterPriseByusercode(String admin_usercode) {
        String sql = "select * from open_enterprise where admin_usercode=?";
        List enterprises = this.cocoDao.query(sql, OpenEnterprise.class, new Object[]{admin_usercode});
        if (enterprises != null && enterprises.size() > 0) {
            return (OpenEnterprise)enterprises.get(0);
        }
        return null;
    }

    @Override
    @Transactional(isolation=Isolation.SERIALIZABLE)
    public void examineEnterPrise(String status, Long id) {
        OpenEnterprise open = (OpenEnterprise)this.cocoDao.findObjById("open_enterprise", (Object)id, OpenEnterprise.class);
        if (open != null) {
            Long if_exist;
            open.setExamine_time(new Date());
            open.setStatus(status);
            this.cocoDao.updatePoJo("open_enterprise", (Object)open);
            if (status_yes.equals(status) && (if_exist = this.cocoDao.queryLong("select count(1) from open_auth_user where enterprise_id=?", new Object[]{open.getId()})) == 0L) {
                String max_application_key = this.cocoDao.queryStr("select max(application_key) from open_auth_user");
                GenerateOpenKey gtopen = GenerateOpenKey.create();
                String application_key = gtopen.generaterOpenKey(max_application_key);
                String application_secret = gtopen.generaterOpenSecret(application_key);
                MM mm = new MM();
                mm.put((Object)"username", (Object)open.getEnterprise_name());
                mm.put((Object)"enterprise_id", (Object)open.getId());
                mm.put((Object)"application_id", (Object)aid);
                mm.put((Object)"application_key", (Object)application_key);
                mm.put((Object)"application_secret", (Object)application_secret);
                this.cocoDao.save("open_auth_user", (Object)mm);
                MM mongodbMM = new MM();
                mongodbMM.put((Object)"open_auth_id", mm.get((Object)"id"));
                mongodbMM.put((Object)"enterprise_id", (Object)open.getId());
                mongodbMM.put((Object)"ifexpire", (Object)3);
                mongodbMM.put((Object)"application_id", (Object)aid);
                mongodbMM.put((Object)"application_key", (Object)application_key);
                mongodbMM.put((Object)"application_secret", (Object)application_secret);
                this.md.save("open_auth_user", (Object)mongodbMM);
            }
        }
    }

    @Override
    public void switchAuth(String status, Long id) {
        Date date = new Date();
        this.cocoDao.update("update open_auth_user set switch_time=?,switch_status=? where  enterprise_id=?", new Object[]{date, status, id});
        Criteria criteria = Criteria.where((String)"enterprise_id").is((Object)id);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("switch_status", (Object)status);
        String switch_time = DateKit.DateTime2Str((Date)date, (SimpleDateFormat)DateKit.getTimeFormat());
        update.set("switch_time", (Object)switch_time);
        this.md.updateFirst(query, update, "open_auth_user");
    }

    @Override
    public Page<MM> getEnterPriseByStatus(String status, Integer pageNo, Integer pageSize) {
        StringBuffer sf = new StringBuffer();
        sf.append("select id,enterprise_name,create_time,status from open_enterprise  where 1=1 ");
        if (!StrKit.isBlank((String)status)) {
            sf.append(" and status='").append(status).append("'");
        }
        Page page = this.cocoDao.paginate(sf.toString(), pageNo.intValue(), pageSize.intValue());
        return page;
    }

    @Override
    public List<MM> searchEnterprise(String enterprise_name) {
        CoCoDsCut.setDataSourceType((String)"ds2");
        StringBuffer sf = new StringBuffer();
        sf.append("select id ,name from is_enterprise_groups where 1=1");
        if (!StrKit.isBlank((String)enterprise_name)) {
            sf.append(" and name like '%").append(enterprise_name).append("%'");
        }
        List list = this.cocoDao.findManyMM(sf.toString());
        CoCoDsCut.setDataSourceType((String)"ds1");
        return list;
    }

    @Override
    public void relateEnterprise(Long open_enterprise_id, Long shopweb_enterprise_id) {
        this.cocoDao.update("update open_auth_user set shopweb_enterprise_id=? where enterprise_id=?", new Object[]{shopweb_enterprise_id, open_enterprise_id});
        Criteria criteria = Criteria.where((String)"enterprise_id").is((Object)open_enterprise_id);
        Query query = new Query((CriteriaDefinition)criteria);
        Update update = new Update();
        update.set("shopweb_enterprise_id", (Object)shopweb_enterprise_id);
        this.md.updateFirst(query, update, "open_auth_user");
    }

    @Override
    public OpenEnterprise getEnterPriseById(Long id) {
        OpenEnterprise openEnterprise = (OpenEnterprise)this.cocoDao.findObjById("open_enterprise", (Object)id, OpenEnterprise.class);
        return openEnterprise;
    }

    @Override
    public String getSwitchStatus(Long id) {
        String switch_status = this.cocoDao.queryStr("select switch_status from open_auth_user where enterprise_id=?", new Object[]{id});
        return switch_status;
    }

    @Override
    public MM getSwitchEnterprise(Long id) {
        Long shopweb_enterprise_id = this.cocoDao.queryLong("select shopweb_enterprise_id from open_auth_user where enterprise_id=?", new Object[]{id});
        if (shopweb_enterprise_id == null) {
            return null;
        }
        CoCoDsCut.setDataSourceType((String)"ds2");
        MM mm = this.cocoDao.findFirstMM("select id ,name from is_enterprise_groups where id=?", new Object[]{shopweb_enterprise_id});
        CoCoDsCut.setDataSourceType((String)"ds1");
        return mm;
    }
}

