/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.passengerflow.sdk.model;

import org.slf4j.MDC;

public class BaseResult<T> {
    private Boolean isError;
    private T data;
    private String code;
    private String message;
    private String requestId = MDC.get((String)"requestId");

    public BaseResult() {
    }

    public Boolean getIsError() {
        return this.isError;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public BaseResult(Boolean isError, T data, String code, String message) {
        this.isError = isError;
        this.data = data;
        this.code = code;
        this.message = message;
    }

    private static <T> BaseResult<T> getInstance(Boolean isError, T data, String code, String message) {
        return new BaseResult<T>(isError, data, code, message);
    }

    public static <T> BaseResult<T> success() {
        return BaseResult.getInstance(false, null, "0", "SUCCESS");
    }

    public static <T> BaseResult<T> success(T data) {
        return BaseResult.getInstance(false, data, "0", "SUCCESS");
    }

    public static <T> BaseResult<T> invalidToken() {
        return BaseResult.getInstance(true, null, "20000", "\u65e0\u6548\u7684token");
    }

    public static <T> BaseResult<T> paramError() {
        return BaseResult.getInstance(true, null, "20001", "\u8bf7\u6c42\u53c2\u6570\u4f20\u9012\u9519\u8bef");
    }

    public static <T> BaseResult<T> noPrivilege() {
        return BaseResult.getInstance(true, null, "99990001", "NO_PRIVILEGE");
    }

    public static <T> BaseResult<T> error() {
        return BaseResult.getInstance(true, null, "1", "\u8bf7\u6c42\u6570\u636e\u5931\u8d25");
    }

    public static <T> BaseResult<T> error(String code, String message) {
        return BaseResult.getInstance(true, null, code, message);
    }
}

