/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.watch.enhancer.subject.gracefulshutdown;

import com.ovopark.watch.enhancer.subject.gracefulshutdown.Shutdown;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownManager {
    private static final Logger log = LoggerFactory.getLogger(ShutdownManager.class);
    private final List<Shutdown> shutdowns;

    public ShutdownManager(List<Shutdown> shutdowns) {
        this.shutdowns = shutdowns;
    }

    public void pause() throws InterruptedException {
        for (Shutdown shutdown : this.shutdowns) {
            shutdown.pause();
            log.info("pause: {}", (Object)shutdown.getClass().getSimpleName());
        }
    }

    public void shutdown(Integer delay) throws InterruptedException {
        for (Shutdown shutdown : this.shutdowns) {
            shutdown.shutdown(delay);
            log.info("shutdown: {}", (Object)shutdown.getClass().getSimpleName());
        }
    }
}

