/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.watch.enhancer.subject.datasource;

import com.ovopark.watch.enhancer.subject.datasource.RoutingDataSourceContext;
import com.ovopark.watch.enhancer.subject.datasource.anno.DataSourceRouting;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=1)
@Aspect
public class RoutingDataSourceAspect {
    private static final Logger log = LoggerFactory.getLogger(RoutingDataSourceAspect.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(dataSourceRouting)")
    public Object routingWithDataSource(ProceedingJoinPoint joinPoint, DataSourceRouting dataSourceRouting) throws Throwable {
        try {
            log.debug("Set DataSource: {}", (Object)dataSourceRouting.value());
            RoutingDataSourceContext.setDataSourceRoutingKey(dataSourceRouting.value());
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            log.debug("Clear DataSource");
            RoutingDataSourceContext.clear();
        }
    }
}

