/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.watch.enhancer.subject.alarm;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.springframework.util.DigestUtils;

public class Image {
    private String base64;
    private String md5;

    public Image(BufferedImage bufferedImage) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferedImage, "png", baos);
        byte[] bytes = baos.toByteArray();
        Base64.Encoder encoder = Base64.getEncoder();
        String pngBase64 = encoder.encodeToString(bytes).trim();
        String md5 = DigestUtils.md5DigestAsHex((byte[])bytes);
        this.base64 = pngBase64;
        this.md5 = md5;
    }

    public String getBase64() {
        return this.base64;
    }

    public String getMd5() {
        return this.md5;
    }

    public void setBase64(String base64) {
        this.base64 = base64;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Image)) {
            return false;
        }
        Image other = (Image)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$base64 = this.getBase64();
        String other$base64 = other.getBase64();
        if (this$base64 == null ? other$base64 != null : !this$base64.equals(other$base64)) {
            return false;
        }
        String this$md5 = this.getMd5();
        String other$md5 = other.getMd5();
        return !(this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Image;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $base64 = this.getBase64();
        result = result * 59 + ($base64 == null ? 43 : $base64.hashCode());
        String $md5 = this.getMd5();
        result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
        return result;
    }

    public String toString() {
        return "Image(base64=" + this.getBase64() + ", md5=" + this.getMd5() + ")";
    }
}

