/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.watch.enhancer.subject.alarm;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.watch.enhancer.subject.alarm.AlarmEnum;
import com.ovopark.watch.enhancer.subject.alarm.AlarmInfo;
import com.ovopark.watch.enhancer.subject.alarm.IAlarmFacade;
import com.ovopark.watch.enhancer.subject.alarm.Image;
import com.ovopark.watch.enhancer.subject.alarm.MarkDown;
import com.ovopark.watch.enhancer.subject.alarm.Text;
import java.awt.image.BufferedImage;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class WeiXinAlarmFacade
implements IAlarmFacade {
    private static final Logger log = LoggerFactory.getLogger(WeiXinAlarmFacade.class);
    private static final String WEB_HOOK_URL = "https://qyapi.weixin.qq.com/cgi-bin/webhook/send?key=";

    private WeiXinAlarmFacade() {
    }

    public static WeiXinAlarmFacade getInstance() {
        return Holder.sInstance;
    }

    @Override
    public void sentText(String key, String content, String title, String[] names) {
        WeiXinAlarmFacade.sent(key, content, AlarmEnum.text, names, null);
    }

    @Override
    public void sentMarkDown(String key, String content, String title, String[] names) {
        WeiXinAlarmFacade.sent(key, content, AlarmEnum.markdown, null, null);
    }

    @Override
    public void sentImage(String key, BufferedImage bufferedImage) {
        WeiXinAlarmFacade.sent(key, bufferedImage);
    }

    private static void sent(String key, String content, AlarmEnum type, String[] mentioned_list, String[] mentioned_mobile_list) {
        String url = WEB_HOOK_URL + key;
        AlarmInfo alarmText = new AlarmInfo();
        if (type != null) {
            alarmText.setMsgtype(type.toString());
        }
        switch (type) {
            case text: {
                Text text = new Text();
                text.setContent(content);
                if (mentioned_list != null && mentioned_list.length > 0) {
                    text.setMentioned_list(mentioned_list);
                }
                if (mentioned_mobile_list != null && mentioned_mobile_list.length > 0) {
                    text.setMentioned_mobile_list(mentioned_mobile_list);
                }
                alarmText.setText(text);
                break;
            }
            case markdown: {
                MarkDown markDown = new MarkDown();
                markDown.setContent(content);
                alarmText.setMarkdown(markDown);
            }
        }
        String json = JSONObject.toJSONString((Object)alarmText);
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        HttpEntity entity = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        log.info("\u8fd4\u56de\u7ed3\u679c:{}", (Object)body);
    }

    private static void sent(String key, BufferedImage bufferedImage) {
        Image image;
        String url = WEB_HOOK_URL + key;
        AlarmInfo alarmText = new AlarmInfo();
        alarmText.setMsgtype(AlarmEnum.image.toString());
        try {
            image = new Image(bufferedImage);
        }
        catch (IOException e) {
            log.error("\u56fe\u7247\u8f6c\u6362\u5931\u8d25", (Throwable)e);
            return;
        }
        alarmText.setImage(image);
        String json = JSONObject.toJSONString((Object)alarmText);
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity entity = new HttpEntity((Object)json, (MultiValueMap)headers);
        ResponseEntity responseEntity = restTemplate.postForEntity(url, (Object)entity, String.class, new Object[0]);
        String body = (String)responseEntity.getBody();
        log.info("\u8fd4\u56de\u7ed3\u679c:{}", (Object)body);
    }

    private static class Holder {
        private static final WeiXinAlarmFacade sInstance = new WeiXinAlarmFacade();

        private Holder() {
        }
    }
}

