/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.watch.enhancer.subject.gracefulshutdown;

import com.ovopark.watch.enhancer.subject.gracefulshutdown.GracefulShutdownProperties;
import com.ovopark.watch.enhancer.subject.gracefulshutdown.ShutdownManager;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;

@Endpoint(id="shutdowngraceful")
@RefreshScope
public class GracefulShutdownEndpoint {
    private static final Logger log = LoggerFactory.getLogger(GracefulShutdownEndpoint.class);
    @Autowired
    private GracefulShutdownProperties gracefulShutdownProperties;
    @Autowired
    private ShutdownManager shutdownManager;
    @Autowired
    private ConfigurableApplicationContext context;
    private Date startShutdown;
    private Date stopShutdown;

    @ReadOperation
    public String invoke() {
        this.startShutdown = new Date();
        new Thread(() -> {
            try {
                this.shutdownManager.pause();
                this.shutdownManager.shutdown(this.gracefulShutdownProperties.getTimeout());
                this.stopShutdown = new Date();
                log.info("We are now in OUT_OF_SERVICE mode, please wait {} second(s)...", (Object)this.gracefulShutdownProperties.getWait());
                Thread.sleep(this.gracefulShutdownProperties.getWait() * 1000);
                this.context.close();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }).start();
        return "done";
    }

    public Date getStartShutdown() {
        return this.startShutdown;
    }
}

