/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ListUtil {
    public static <T> List<List<T>> splitList(List<T> list, int groupSize) {
        int length = list.size();
        int num = (length + groupSize - 1) / groupSize;
        ArrayList<List<T>> newList = new ArrayList<List<T>>(num);
        for (int i = 0; i < num; ++i) {
            int fromIndex = i * groupSize;
            int toIndex = Math.min((i + 1) * groupSize, length);
            newList.add(list.subList(fromIndex, toIndex));
        }
        return newList;
    }

    public static <T> List<T> subList(List<T> source, Integer pageNum, Integer pageSize) {
        int fromIndex = (pageNum - 1) * pageSize;
        if (source.size() < fromIndex) {
            return Collections.emptyList();
        }
        int toIndex = Math.min(pageNum * pageSize, source.size());
        return source.subList(fromIndex, toIndex);
    }
}

