/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.common.util;

public class LogUtil {
    public static String getStackTraceInfo(Exception e) {
        StringBuilder sb = new StringBuilder();
        Throwable current = e;
        for (int depth = 0; current != null && depth < 10; current = current.getCause(), ++depth) {
            if (depth > 0) {
                sb.append("Caused by: ");
            }
            sb.append("Exception name: ").append(current.getClass().getName()).append("\n");
            sb.append("Exception message: ").append(current.getMessage()).append("\n");
            StackTraceElement[] stackTrace = current.getStackTrace();
            int framesToPrint = depth == 0 ? Math.min(50, stackTrace.length) : Math.min(10, stackTrace.length);
            for (int i = 0; i < framesToPrint; ++i) {
                sb.append("    at ").append(stackTrace[i]).append("\n");
            }
            if (stackTrace.length <= framesToPrint) continue;
            sb.append("    ... ").append(stackTrace.length - framesToPrint).append(" more\n");
            if (current == null) continue;
            sb.append("\n");
        }
        return sb.toString();
    }
}

