/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.common.util;

import com.ovopark.device.common.util.LogUtil;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static Logger log = LoggerFactory.getLogger(LogUtil.class);

    public static String getRemoteIp(HttpServletRequest request) {
        String realIp = request.getHeader("X-Real-IP");
        String remoteIp = request.getHeader("x-forwarded-for");
        if (StringUtils.isNotEmpty((CharSequence)realIp)) {
            log.info("X-Real-IP:" + realIp);
        }
        if (StringUtils.isNotEmpty((CharSequence)remoteIp)) {
            log.info("x-forwarded-for:" + remoteIp);
            if (remoteIp.contains(",")) {
                remoteIp = remoteIp.split(",")[0].trim();
            }
            return remoteIp;
        }
        return request.getRemoteAddr();
    }

    public static String getPlatform(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        String platform = null;
        platform = userAgent != null ? (userAgent.contains("Android") || userAgent.contains("okhttp") ? "Android" : (userAgent.contains("iOS") ? "iOS" : "web")) : "unknown";
        return platform;
    }
}

