/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.appkey.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.device.modules.appkey.enums.AppkeyEnum;
import com.ovopark.device.modules.appkey.model.mo.DeviceBackMo;
import com.ovopark.device.modules.appkey.model.mo.GetThirdDeviceListMo;
import com.ovopark.device.modules.appkey.mysql.ThirdDevice;
import com.ovopark.device.modules.appkey.mysql.ThirdDeviceMapper;
import com.ovopark.device.modules.appkey.service.ThirdDeviceService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ThirdDeviceServiceImpl
implements ThirdDeviceService {
    @Autowired
    private ThirdDeviceMapper thirdDeviceMapper;

    @Override
    public void add(ThirdDevice thirdDevice) {
        this.thirdDeviceMapper.insert(thirdDevice);
    }

    @Override
    public void deviceToBack(DeviceBackMo mo) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.eq(ThirdDevice::getId, (Object)mo.getId())).set(ThirdDevice::getDelFlag, (Object)0);
        if (StringUtils.isNotEmpty((CharSequence)mo.getChannelName())) {
            updateWrapper.set(ThirdDevice::getChannelName, (Object)mo.getChannelName());
        }
        if (StringUtils.isNotEmpty((CharSequence)mo.getIpcSerial())) {
            updateWrapper.set(ThirdDevice::getIpcSerial, (Object)mo.getIpcSerial());
        }
        this.thirdDeviceMapper.update(null, (Wrapper)updateWrapper);
    }

    @Override
    public ThirdDevice getByIpAndChannelNo(@NotNull String mainDeviceSerial, @NotNull Integer channelNo, @NotNull AppkeyEnum thirdType, Integer delFlag) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ThirdDevice::getMainDeviceSerial, (Object)mainDeviceSerial)).eq(ThirdDevice::getChannelNo, (Object)channelNo)).eq(ThirdDevice::getThirdType, (Object)thirdType.getType());
        if (delFlag != null) {
            queryWrapper.eq(ThirdDevice::getDelFlag, (Object)delFlag);
        }
        return (ThirdDevice)this.thirdDeviceMapper.selectOne((Wrapper)queryWrapper);
    }

    @Override
    public List<ThirdDevice> getThirdDeviceList(GetThirdDeviceListMo mo) {
        List<Integer> depIds = mo.getDepIds();
        Integer groupId = mo.getGroupId();
        String appKey = mo.getAppKey();
        String channelName = mo.getChannelName();
        Integer thirdType = mo.getThirdType();
        Integer bindFlag = mo.getBindFlag();
        Integer delFlag = mo.getDelFlag();
        if (CollectionUtils.isEmpty(depIds)) {
            bindFlag = 1;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(groupId != null, ThirdDevice::getGroupId, (Object)groupId)).eq(thirdType != null, ThirdDevice::getThirdType, (Object)thirdType)).eq(StringUtils.isNotEmpty((CharSequence)appKey), ThirdDevice::getAppKey, (Object)appKey)).in(CollectionUtils.isEmpty(depIds), ThirdDevice::getDepId, depIds)).eq(delFlag != null, ThirdDevice::getDelFlag, (Object)delFlag)).like(StringUtils.isNotEmpty((CharSequence)channelName), ThirdDevice::getChannelName, (Object)("%" + channelName + "%"));
        if (bindFlag != null) {
            if (bindFlag == 1) {
                queryWrapper.isNotNull(ThirdDevice::getDepId);
            } else {
                queryWrapper.isNull(ThirdDevice::getDepId);
            }
        }
        Integer pageNum = mo.getPageNum();
        Integer pageSize = mo.getPageSize();
        if (pageNum != null && pageSize != null) {
            if (pageNum <= 0) {
                throw new IllegalArgumentException("\u9875\u7801\u5fc5\u987b\u5927\u4e8e0");
            }
            if (pageSize <= 0) {
                throw new IllegalArgumentException("\u6bcf\u9875\u6761\u6570\u5fc5\u987b\u5927\u4e8e0");
            }
            Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
            return ((Page)this.thirdDeviceMapper.selectPage((IPage)page, (Wrapper)queryWrapper)).getRecords();
        }
        return this.thirdDeviceMapper.selectList((Wrapper)queryWrapper);
    }
}

