/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.integration.api.config;

import com.ovopark.device.modules.integration.api.enums.IntegrationEnum;
import com.ovopark.device.modules.integration.api.exception.HealthCheck;
import com.ovopark.device.modules.integration.api.exception.ServiceNotFoundException;
import com.ovopark.device.modules.integration.api.exception.ServiceUnavailableException;
import com.ovopark.device.modules.integration.api.service.BaseDevManageService;
import com.ovopark.device.modules.integration.api.service.BaseOnlineStatusService;
import com.ovopark.device.modules.integration.api.service.BaseVendorService;
import com.ovopark.device.modules.integration.api.service.BaseVideoService;
import io.micrometer.common.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VendorServiceManager {
    private static final Logger log = LoggerFactory.getLogger(VendorServiceManager.class);
    private final Map<String, BaseVideoService> videoServices = new ConcurrentHashMap<String, BaseVideoService>();
    private final Map<String, BaseOnlineStatusService> statusServices = new ConcurrentHashMap<String, BaseOnlineStatusService>();
    private final Map<String, BaseDevManageService> devManageServices = new ConcurrentHashMap<String, BaseDevManageService>();

    public VendorServiceManager(List<BaseVideoService> videoServices, List<BaseOnlineStatusService> statusServices, List<BaseDevManageService> devManageServices) {
        log.info("|VendorServiceManager init start ------------------------------------");
        videoServices.forEach(service -> {
            this.videoServices.put(service.getVendorType(), (BaseVideoService)service);
            log.info("|videoServices: type={}, class={}", (Object)service.getVendorType(), (Object)service.getClass().getName());
        });
        statusServices.forEach(service -> {
            this.statusServices.put(service.getVendorType(), (BaseOnlineStatusService)service);
            log.info("|statusServices: type={}, class={}", (Object)service.getVendorType(), (Object)service.getClass().getName());
        });
        devManageServices.forEach(service -> {
            this.devManageServices.put(service.getVendorType(), (BaseDevManageService)service);
            log.info("|devManageServices: type={}, class={}", (Object)service.getVendorType(), (Object)service.getClass().getName());
        });
        log.info("|VendorServiceManager init end ------------------------------------");
    }

    public BaseVideoService getVideoService(IntegrationEnum vendorType) {
        return this.getService(this.videoServices, vendorType.getType(), "VideoService");
    }

    public BaseOnlineStatusService getStatusService(IntegrationEnum vendorType) {
        return this.getService(this.statusServices, vendorType.getType(), "StatusService");
    }

    public BaseDevManageService getDevManageService(IntegrationEnum vendorType) {
        return this.getService(this.devManageServices, vendorType.getType(), "DevManageService");
    }

    private <T extends BaseVendorService> T getService(Map<String, T> services, String vendorType, String serviceName) {
        HealthCheck healthCheck;
        if (services == null) {
            throw new IllegalArgumentException("services map cannot be null");
        }
        if (StringUtils.isEmpty((String)vendorType)) {
            throw new IllegalArgumentException("vendorType cannot be empty");
        }
        BaseVendorService service = (BaseVendorService)services.get(vendorType);
        if (service == null) {
            log.error("\u672a\u627e\u5230\u5382\u5546[{}]\u7684{}\u5b9e\u73b0", (Object)vendorType, (Object)serviceName);
            throw new ServiceNotFoundException(String.format("\u672a\u627e\u5230\u5382\u5546[%s]\u7684%s\u5b9e\u73b0", vendorType, serviceName));
        }
        if (service instanceof HealthCheck && !(healthCheck = (HealthCheck)((Object)service)).isHealthy()) {
            String details = healthCheck.getHealthDetails();
            log.error("\u5382\u5546[{}]\u7684{}\u670d\u52a1\u4e0d\u53ef\u7528: {}", new Object[]{vendorType, serviceName, details});
            throw new ServiceUnavailableException(String.format("\u5382\u5546[%s]\u7684%s\u670d\u52a1\u5f53\u524d\u4e0d\u53ef\u7528: %s", vendorType, serviceName, details));
        }
        return (T)service;
    }
}

