/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.integration.hik.impl;

import com.ovopark.device.modules.appkey.enums.AppkeyEnum;
import com.ovopark.device.modules.appkey.mo.DeviceBackMo;
import com.ovopark.device.modules.appkey.mysql.ThirdDevice;
import com.ovopark.device.modules.appkey.service.ThirdDeviceService;
import com.ovopark.device.modules.integration.api.enums.IntegrationEnum;
import com.ovopark.device.modules.integration.api.model.req.SnapshotByHandReq;
import com.ovopark.device.modules.integration.api.service.BaseDevManageService;
import com.ovopark.device.modules.integration.hik.manage.HikSdkApiManage;
import com.ovopark.device.thirdparty.hik.model.req.HikCaptureReq;
import com.ovopark.device.thirdparty.hik.model.res.HikDevice1Res;
import com.ovopark.device.thirdparty.hik.model.res.HikDeviceChannelRes;
import com.ovopark.device.thirdparty.hik.model.res.HikGroupItemRes;
import com.ovopark.device.thirdparty.ovoIot.model.common.CommonException;
import com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum;
import java.time.LocalDateTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="hikDevManageService")
public class HikDevManageServiceImpl
implements BaseDevManageService {
    private static final Logger log = LoggerFactory.getLogger(HikDevManageServiceImpl.class);
    @Autowired
    private HikSdkApiManage hikSdkApiManage;
    @Autowired
    private ThirdDeviceService thirdDeviceService;

    public void init(String appId, Integer groupId) {
        List<HikGroupItemRes> allGroups = this.hikSdkApiManage.getAllGroups(appId);
        if (allGroups == null || allGroups.size() == 0) {
            log.error("hikSdkApiManage.getAllGroups error:{}", (Object)"\u7ec4\u5217\u8868\u4e3a\u7a7a");
            return;
        }
        for (HikGroupItemRes hikGroupItemRes : allGroups) {
            String groupNo = hikGroupItemRes.getGroupNo();
            List<HikDevice1Res> groupDevices = this.hikSdkApiManage.getGroupDevices(appId, groupNo);
            if (groupDevices == null || groupDevices.isEmpty()) {
                log.error("hikSdkApiManage.getGroupDevices error:{}", (Object)"\u7ec4\u5185\u8bbe\u5907\u5217\u8868\u4e3a\u7a7a");
                continue;
            }
            for (HikDevice1Res hikDevice1Res : groupDevices) {
                String mainDeviceNo = hikDevice1Res.getDeviceSerial();
                List<HikDeviceChannelRes> channelList = this.hikSdkApiManage.getChannelList(appId, mainDeviceNo);
                if (channelList == null || channelList.isEmpty()) {
                    log.warn("hikSdkApiManage.getChannelList error:{}", (Object)"\u5b50\u8bbe\u5907\u5217\u8868\u4e3a\u7a7a");
                    continue;
                }
                for (HikDeviceChannelRes hikDeviceChannelRes : channelList) {
                    String deviceSerial = hikDeviceChannelRes.getDeviceSerial();
                    String channelId = hikDeviceChannelRes.getChannelId();
                    String channelName = hikDeviceChannelRes.getChannelName();
                    Integer channelNo = hikDeviceChannelRes.getChannelNo();
                    Integer channelStatus = hikDeviceChannelRes.getChannelStatus();
                    String channelType = hikDeviceChannelRes.getChannelType();
                    Integer isUse = hikDeviceChannelRes.getIsUse();
                    String ipcSerial = hikDeviceChannelRes.getIpcSerial();
                    String childDeviceModel = hikDeviceChannelRes.getChildDeviceModel();
                    if (StringUtils.isEmpty((CharSequence)ipcSerial)) continue;
                    ThirdDevice byIpAndChannelNo = this.thirdDeviceService.getByMainDeviceSerialAndChannelNo(deviceSerial, channelNo, AppkeyEnum.hik, null);
                    if (byIpAndChannelNo != null) {
                        DeviceBackMo deviceBackMo = new DeviceBackMo();
                        deviceBackMo.setId(byIpAndChannelNo.getId());
                        deviceBackMo.setIpcSerial(byIpAndChannelNo.getIpcSerial());
                        deviceBackMo.setChannelName(byIpAndChannelNo.getChannelName());
                        this.thirdDeviceService.deviceToBack(deviceBackMo);
                        continue;
                    }
                    ThirdDevice thirdDeviceAdd = new ThirdDevice();
                    thirdDeviceAdd.setMainDeviceSerial(deviceSerial);
                    thirdDeviceAdd.setIpcSerial(ipcSerial);
                    thirdDeviceAdd.setChannelNo(channelNo);
                    thirdDeviceAdd.setThirdType(AppkeyEnum.hik.getType());
                    thirdDeviceAdd.setChannelName(channelName);
                    thirdDeviceAdd.setDelFlag(Integer.valueOf(0));
                    thirdDeviceAdd.setAppKey(appId);
                    thirdDeviceAdd.setCreateAt(LocalDateTime.now());
                    thirdDeviceAdd.setGroupId(groupId);
                    this.thirdDeviceService.add(thirdDeviceAdd);
                }
            }
        }
    }

    public String snapshotByHand(SnapshotByHandReq req) {
        Integer channelId;
        String mainSerialNo = req.getMainSerialNo();
        ThirdDevice byMainDeviceSerialAndChannelNo = this.thirdDeviceService.getByMainDeviceSerialAndChannelNo(mainSerialNo, channelId = req.getChannelId(), AppkeyEnum.hik, Integer.valueOf(0));
        if (byMainDeviceSerialAndChannelNo == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        HikCaptureReq hikCaptureReq = new HikCaptureReq();
        hikCaptureReq.setDeviceSerial(mainSerialNo);
        hikCaptureReq.setChannelNo(channelId);
        hikCaptureReq.setQuality(Integer.valueOf(3));
        hikCaptureReq.setAppKey(byMainDeviceSerialAndChannelNo.getAppKey());
        return this.hikSdkApiManage.captur(hikCaptureReq);
    }

    public String getVendorType() {
        return IntegrationEnum.Hik.getType();
    }
}

