/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.integration.hik.manage;

import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.modules.appkey.enums.AppkeyEnum;
import com.ovopark.device.modules.appkey.mysql.ModuleThirdAppIdSecret;
import com.ovopark.device.modules.appkey.service.ModuleThirdAppIdSecretService;
import com.ovopark.device.thirdparty.hik.api.HikSdkTokenApi;
import com.ovopark.device.thirdparty.hik.model.req.HikTokenReq;
import com.ovopark.device.thirdparty.hik.model.res.HikTokenRes;
import jakarta.annotation.Resource;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class HikTokenManage {
    private static final Logger log = LoggerFactory.getLogger(HikTokenManage.class);
    @Autowired
    private HikSdkTokenApi hikSdkTokenApi;
    @Resource(name="deviceStringRedisTemplate")
    public StringRedisTemplate deviceStringRedisTemplate;
    @Autowired
    private ModuleThirdAppIdSecretService thirdAppIdSecretService;

    public String getToken(String appKey) {
        String key = "hik:token:" + appKey;
        String token = (String)this.deviceStringRedisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isEmpty((CharSequence)token)) {
            ModuleThirdAppIdSecret appKeyObj = this.getAppKey(appKey);
            HikTokenReq req = new HikTokenReq(appKey, appKeyObj.getAppSecret());
            HikTokenRes token1 = this.hikSdkTokenApi.getToken(req);
            log.info("hik token:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)token1));
            this.deviceStringRedisTemplate.opsForValue().set((Object)key, (Object)token1.getAccess_token(), (long)token1.getExpires_in().intValue(), TimeUnit.SECONDS);
            return token1.getAccess_token();
        }
        return token;
    }

    public void refreshToken(String appKey) {
        String key = "hik:token:" + appKey;
        ModuleThirdAppIdSecret appKeyObj = this.getAppKey(appKey);
        HikTokenReq req = new HikTokenReq(appKey, appKeyObj.getAppSecret());
        HikTokenRes token1 = this.hikSdkTokenApi.getToken(req);
        log.info("hik token:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)token1));
        this.deviceStringRedisTemplate.opsForValue().set((Object)key, (Object)token1.getAccess_token(), (long)token1.getExpires_in().intValue(), TimeUnit.SECONDS);
    }

    private ModuleThirdAppIdSecret getAppKey(String appId) {
        return this.thirdAppIdSecretService.getThirdAppIdSecret(appId, AppkeyEnum.hik);
    }
}

