/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.integration.hik.impl;

import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.modules.appkey.enums.AppkeyEnum;
import com.ovopark.device.modules.appkey.mysql.ThirdDevice;
import com.ovopark.device.modules.appkey.service.ThirdDeviceService;
import com.ovopark.device.modules.integration.api.enums.IntegrationEnum;
import com.ovopark.device.modules.integration.api.model.req.BaseVideoPlayBackReq;
import com.ovopark.device.modules.integration.api.model.req.BaseVideoPlayReq;
import com.ovopark.device.modules.integration.api.model.res.BasePlayVideoBackRes;
import com.ovopark.device.modules.integration.api.model.res.BasePlayVideoRes;
import com.ovopark.device.modules.integration.api.service.BaseVideoService;
import com.ovopark.device.modules.integration.hik.manage.HikSdkApiManage;
import com.ovopark.device.thirdparty.hik.model.req.HikGetVideoUrlReq;
import com.ovopark.device.thirdparty.hik.model.res.HikGetVideoUrlRes;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HikVideoServiceImpl
implements BaseVideoService {
    private static final Logger log = LoggerFactory.getLogger(HikVideoServiceImpl.class);
    @Autowired
    private HikSdkApiManage hikSdkApiManage;
    @Autowired
    private ThirdDeviceService thirdDeviceService;

    public String getVendorType() {
        return IntegrationEnum.Hik.getType();
    }

    public List<String> getSdkNameList() {
        return null;
    }

    public BasePlayVideoRes startVideoPlay(BaseVideoPlayReq req) {
        Integer channelId;
        Boolean mainStreamFlag = req.getMainStreamFlag();
        String serialNo = req.getSerialNo();
        ThirdDevice byMainDeviceSerialAndChannelNo = this.thirdDeviceService.getByMainDeviceSerialAndChannelNo(serialNo, channelId = req.getChannelId(), AppkeyEnum.hik, Integer.valueOf(0));
        if (byMainDeviceSerialAndChannelNo == null) {
            log.error("\u8bbe\u5907\u4e0d\u5b58\u5728");
            return null;
        }
        HikGetVideoUrlReq hikGetVideoUrlReq = new HikGetVideoUrlReq();
        hikGetVideoUrlReq.setDeviceSerial(serialNo);
        hikGetVideoUrlReq.setChannelNo(channelId);
        hikGetVideoUrlReq.setProtocol("4");
        hikGetVideoUrlReq.setQuality(mainStreamFlag != false ? "1" : "2");
        hikGetVideoUrlReq.setAppKey(byMainDeviceSerialAndChannelNo.getAppKey());
        hikGetVideoUrlReq.setSupportH265(Integer.valueOf(1));
        HikGetVideoUrlRes videoUrl = this.hikSdkApiManage.getVideoUrl(hikGetVideoUrlReq);
        if (videoUrl == null) {
            log.error("\u83b7\u53d6\u89c6\u9891\u64ad\u653e\u5730\u5740\u5931\u8d25");
            return null;
        }
        hikGetVideoUrlReq.setProtocol("2");
        HikGetVideoUrlRes hlsUrl = this.hikSdkApiManage.getVideoUrl(hikGetVideoUrlReq);
        if (hlsUrl == null) {
            log.error("\u83b7\u53d6\u89c6\u9891\u64ad\u653e\u5730\u5740\u5931\u8d25");
            return null;
        }
        return BasePlayVideoRes.createHikVideo((String)videoUrl.getUrl(), (String)hlsUrl.getUrl());
    }

    public BasePlayVideoBackRes startVideoPlayBack(BaseVideoPlayBackReq req) {
        Integer channelId;
        String serialNo = req.getSerialNo();
        ThirdDevice byMainDeviceSerialAndChannelNo = this.thirdDeviceService.getByMainDeviceSerialAndChannelNo(serialNo, channelId = req.getChannelId(), AppkeyEnum.hik, Integer.valueOf(0));
        if (byMainDeviceSerialAndChannelNo == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        HikGetVideoUrlReq hikGetVideoUrlReq = new HikGetVideoUrlReq();
        hikGetVideoUrlReq.setDeviceSerial(serialNo);
        hikGetVideoUrlReq.setChannelNo(channelId);
        hikGetVideoUrlReq.setProtocol("4");
        hikGetVideoUrlReq.setQuality("1");
        hikGetVideoUrlReq.setType("2");
        hikGetVideoUrlReq.setAppKey(byMainDeviceSerialAndChannelNo.getAppKey());
        hikGetVideoUrlReq.setStartTime(req.getStartTime());
        hikGetVideoUrlReq.setStopTime(req.getEndTime());
        hikGetVideoUrlReq.setSupportH265(Integer.valueOf(1));
        HikGetVideoUrlRes videoUrl = this.hikSdkApiManage.getVideoUrl(hikGetVideoUrlReq);
        String url = videoUrl.getUrl();
        hikGetVideoUrlReq.setProtocol("2");
        HikGetVideoUrlRes hls = this.hikSdkApiManage.getVideoUrl(hikGetVideoUrlReq);
        return BasePlayVideoBackRes.createHikVideo((String)url, (String)hls.getUrl());
    }
}

