/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.integration.ovo.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.device.cloud.api.VideoFeignService;
import com.ovopark.device.common.response.BaseResult;
import com.ovopark.device.modules.integration.api.model.req.BaseVideoPlayBackReq;
import com.ovopark.device.modules.integration.api.model.res.BasePlayVideoBackRes;
import com.ovopark.device.modules.integration.ovo.impl.CouldWatchService;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.sdk.common.model.vo.GetYzsDeviceStatusByMac;
import com.ovopark.device.thirdparty.ovoIot.config.OvoIotConfig;
import com.ovopark.device.thirdparty.ovoIot.model.GeneralDataStatusRes;
import com.ovopark.device.thirdparty.ovoIot.model.GetDataSourceBaseMo;
import com.ovopark.device.thirdparty.ovoIot.model.GetDoorLockStateRes;
import com.ovopark.device.thirdparty.ovoIot.model.SetDoorLockStateRes;
import com.ovopark.device.thirdparty.ovoIot.model.StartVideoCallRes;
import com.ovopark.device.thirdparty.ovoIot.model.common.CommonException;
import com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum;
import com.ovopark.device.thirdparty.ovoIot.model.mms.channel.MmsCreateChannelBaseRes;
import com.ovopark.device.thirdparty.ovoIot.model.mms.channel.MmsCreateChannelInfoResWebRtc;
import com.ovopark.device.thirdparty.ovoIot.model.req.CloudWatchPlayAudioReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.DoorLockStateReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetCloudGuardEventCBReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetCloudGuardStateReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetWelcomeVideoReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.StartVideoCallReq;
import com.ovopark.device.thirdparty.ovoIot.service.NvrService;
import com.ovopark.device.thirdparty.ovoIot.service.OvoVideoService;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CouldWatchServiceImpl
implements CouldWatchService {
    private static final Logger log = LoggerFactory.getLogger(CouldWatchServiceImpl.class);
    @Autowired
    private NvrService nvrService;
    @Autowired
    private DeviceStatusMapper deviceStatusMapper;
    @Autowired
    private OvoVideoService videoService;
    @Autowired
    private OvoIotConfig ovoIotConfig;
    @Resource
    private DeviceStatusService deviceStatusService;
    @Resource
    private VideoFeignService videoFeignService;
    @Value(value="${yzs.event-url}")
    private String eventUrl;
    @Resource
    private DepartmentApi departmentApi;

    private DeviceStatus getDeviceMacByDepId(Integer depId) {
        List deviceStatuses = this.deviceStatusService.listDevice(depId);
        if (CollectionUtils.isEmpty((Collection)deviceStatuses)) {
            return null;
        }
        for (DeviceStatus deviceStatus : deviceStatuses) {
            if (deviceStatus.getDType() == null || 20 != deviceStatus.getDType() || !StringUtils.equalsIgnoreCase((CharSequence)"Dolphin1-C", (CharSequence)deviceStatus.getDeviceType())) continue;
            return deviceStatus;
        }
        return null;
    }

    @Override
    public GetDoorLockStateRes getDoorLockState(Integer depId) {
        DeviceStatus deviceStatus = this.getDeviceMacByDepId(depId);
        if (deviceStatus == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        if (!CouldWatchServiceImpl.supportWatch(deviceStatus.getExtendCapacity(), 84)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        GetDoorLockStateRes doorLockState = this.nvrService.getDoorLockState(deviceStatus.getMac());
        if (doorLockState != null && !"comm_success".equals(doorLockState.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return doorLockState;
    }

    @Override
    public com.ovopark.module.shared.BaseResult setDoorLockState(Integer depId, String state, Integer id, Integer unlock_duration, String direction) {
        DeviceStatus deviceStatus = this.getDeviceMacByDepId(depId);
        if (deviceStatus == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        DoorLockStateReq stateReq = new DoorLockStateReq();
        stateReq.setState(state);
        stateReq.setId(id);
        if (unlock_duration != null) {
            stateReq.setUnlock_duration(unlock_duration);
        }
        stateReq.setDirection(direction);
        if (!CouldWatchServiceImpl.supportWatch(deviceStatus.getExtendCapacity(), 84)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        SetDoorLockStateRes doorLockState = this.nvrService.setDoorLockState(deviceStatus.getMac(), stateReq);
        if (doorLockState != null && !"comm_success".equals(doorLockState.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }

    @Override
    public String cloudWatchVoiceCall(Integer depId, Integer deviceId) {
        String token = null;
        BaseVideoPlayBackReq req = new BaseVideoPlayBackReq();
        DeviceStatus deviceStatus = this.getDeviceMacByDepId(depId);
        if (deviceStatus == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        req.setSerialNo(deviceStatus.getMac());
        req.setChannelId(deviceStatus.getChannelId());
        token = this.getToken(deviceStatus.getGroupId(), deviceStatus.getDepId(), 1);
        if (token == null) {
            log.info("cloudWatchVoiceCall\u83b7\u53d6\u4f01\u4e1a\u64ad\u653etoken\u5931\u8d25\uff1a{}", (Object)token);
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        BasePlayVideoBackRes<BasePlayVideoBackRes.OvoVideoBackInfo> ovoVideoBackInfoBasePlayVideoBackRes = this.cloudWatchVoiceCall(req, token);
        return ovoVideoBackInfoBasePlayVideoBackRes.getOvoVideoBackInfo().getWebrtcSignalWss();
    }

    private BasePlayVideoBackRes<BasePlayVideoBackRes.OvoVideoBackInfo> cloudWatchVoiceCall(BaseVideoPlayBackReq req, String token) {
        String serialNo = req.getSerialNo();
        Integer channelId = req.getChannelId();
        GetDataSourceBaseMo getDataSourceBaseMo = new GetDataSourceBaseMo();
        String realPlayWebRtcDataSource = getDataSourceBaseMo.cloudWatchVoiceCall(this.ovoIotConfig.getDmsProxyUrl().replace("http://", "").replace("https://", ""), serialNo, channelId, Boolean.valueOf(true), Integer.valueOf(0), Boolean.valueOf(true));
        log.info("cloudWatchVoiceCall\u521b\u5efawebrtc\u6570\u636e\u6e90\uff1a{}", (Object)realPlayWebRtcDataSource);
        MmsCreateChannelBaseRes channel = this.videoService.createChannel(realPlayWebRtcDataSource, token);
        log.info("cloudWatchVoiceCall\u521b\u5efawebrtc\u901a\u9053\u8fd4\u56de\uff1a{}", (Object)channel);
        MmsCreateChannelInfoResWebRtc channelinfo = channel.getChannelinfoWebRtc();
        String webrtcSignalUrl = channelinfo.getWebrtcSignalUrl();
        String webrtcSignalWss = channelinfo.getWebrtcSignalWss();
        String webrtcSignalWssPriv = channelinfo.getWebrtcSignalWssPriv();
        return BasePlayVideoBackRes.createOvoWebRtcVideo((String)webrtcSignalUrl, (String)webrtcSignalWss, (String)webrtcSignalWssPriv);
    }

    @Override
    public com.ovopark.module.shared.BaseResult cloudWatchPlayAudio(Integer depId, CloudWatchPlayAudioReq req) {
        DeviceStatus deviceStatus = this.getDeviceMacByDepId(depId);
        if (deviceStatus == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        if (!CouldWatchServiceImpl.supportWatch(deviceStatus.getExtendCapacity(), 86)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        GeneralDataStatusRes generalDataStatusRes = this.nvrService.cloudWatchPlayAudio(deviceStatus.getMac(), req);
        if (generalDataStatusRes != null && !"comm_success".equals(generalDataStatusRes.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }

    @Override
    public GetYzsDeviceStatusByMac getYzsDeviceStatusByMac(String mac) {
        GetYzsDeviceStatusByMac deviceStatusByMac = new GetYzsDeviceStatusByMac();
        LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getIsDelete, (Object)0)).eq(DeviceStatus::getMac, (Object)mac)).eq(DeviceStatus::getDType, (Object)240);
        List deviceStatuses = this.deviceStatusMapper.selectList((Wrapper)eq);
        if (!CollectionUtils.isEmpty((Collection)deviceStatuses) && deviceStatuses.size() > 0) {
            DeviceStatus deviceStatus = (DeviceStatus)deviceStatuses.get(0);
            try {
                com.ovopark.organize.common.base.BaseResult departmentById = this.departmentApi.getDepartmentById(deviceStatus.getDepId());
                deviceStatusByMac.setDepName(((DepartmentPojo)departmentById.getData()).getName());
            }
            catch (Exception e) {
                log.error("getYzsDeviceStatusByMac\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            deviceStatusByMac.setMac(deviceStatus.getMac());
            deviceStatusByMac.setDeviceName(deviceStatus.getDeviceName());
            deviceStatusByMac.setDepId(deviceStatus.getDepId());
            deviceStatusByMac.setEnterpriseId(deviceStatus.getGroupId());
        }
        return deviceStatusByMac;
    }

    @Override
    public com.ovopark.module.shared.BaseResult startVideoCall(Integer depId, String url) {
        DeviceStatus deviceStatus = this.getDeviceMacByDepId(depId);
        if (deviceStatus == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        if (!CouldWatchServiceImpl.supportWatch(deviceStatus.getExtendCapacity(), 85)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        StartVideoCallReq stateReq = new StartVideoCallReq();
        stateReq.setUrl(url);
        StartVideoCallRes doorLockState = this.nvrService.startVideoCall(deviceStatus.getMac(), stateReq);
        if (doorLockState != null && !"comm_success".equals(doorLockState.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }

    @Override
    public com.ovopark.module.shared.BaseResult stopVideoCall(Integer depId) {
        DeviceStatus deviceStatus = this.getDeviceMacByDepId(depId);
        if (deviceStatus == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        if (!CouldWatchServiceImpl.supportWatch(deviceStatus.getExtendCapacity(), 85)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        StartVideoCallRes doorLockState = this.nvrService.stopVideoCall(deviceStatus.getMac(), null);
        if (doorLockState != null && !"comm_success".equals(doorLockState.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }

    private String getToken(Integer enterpriseId, Integer deptId, Integer groupType) {
        BaseResult tokenByDeptId = this.videoFeignService.getTokenByDeptId(enterpriseId, deptId, groupType);
        return (String)tokenByDeptId.getData();
    }

    @Override
    public com.ovopark.module.shared.BaseResult setCloudGuardEventCB(Integer nvrId) {
        DeviceStatus nvr = this.deviceStatusService.getById(nvrId);
        if (nvr == null || nvr.getIsDelete() == 1) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        if (!CouldWatchServiceImpl.supportWatch(nvr.getExtendCapacity(), 87)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        SetCloudGuardEventCBReq req = new SetCloudGuardEventCBReq();
        req.setDepId(nvr.getDepId());
        req.setEventType(Arrays.asList(1));
        req.setUrl(this.eventUrl);
        GeneralDataStatusRes generalDataStatusRes = this.nvrService.setCloudGuardEventCB(nvr.getMac(), req);
        if (generalDataStatusRes != null && !"comm_success".equals(generalDataStatusRes.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }

    @Override
    public com.ovopark.module.shared.BaseResult setWelcomeVideo(Integer nvrId, String url) {
        DeviceStatus nvr = this.deviceStatusService.getById(nvrId);
        if (nvr == null || nvr.getIsDelete() == 1) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        if (!CouldWatchServiceImpl.supportWatch(nvr.getExtendCapacity(), 88)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        SetWelcomeVideoReq req = new SetWelcomeVideoReq();
        req.setUrl(url);
        req.setEnbale(Boolean.valueOf(true));
        GeneralDataStatusRes generalDataStatusRes = this.nvrService.setWelcomeVideo(nvr.getMac(), req);
        if (generalDataStatusRes != null && !"comm_success".equals(generalDataStatusRes.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }

    @Override
    public com.ovopark.module.shared.BaseResult setCloudGuardState(Integer depId, String state) {
        DeviceStatus deviceStatus = this.getDeviceMacByDepId(depId);
        if (deviceStatus == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        if (!CouldWatchServiceImpl.supportWatch(deviceStatus.getExtendCapacity(), 90)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        SetCloudGuardStateReq req = new SetCloudGuardStateReq();
        req.setState(state);
        GeneralDataStatusRes generalDataStatusRes = this.nvrService.setCloudGuardState(deviceStatus.getMac(), req);
        if (generalDataStatusRes != null && !"comm_success".equals(generalDataStatusRes.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }

    public static boolean supportWatch(String capacity, Integer places) {
        int support;
        return StringUtils.isNotEmpty((CharSequence)capacity) && capacity.length() > places && (support = Integer.parseInt(capacity.substring(places - 1, places))) == 1;
    }
}

