/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.integration.ovo.impl;

import com.ovopark.device.modules.integration.api.enums.IntegrationEnum;
import com.ovopark.device.modules.integration.api.model.req.BaseVideoPlayBackReq;
import com.ovopark.device.modules.integration.api.model.req.BaseVideoPlayReq;
import com.ovopark.device.modules.integration.api.model.req.VendorVideoOvoParams;
import com.ovopark.device.modules.integration.api.model.res.BasePlayVideoBackRes;
import com.ovopark.device.modules.integration.api.model.res.BasePlayVideoRes;
import com.ovopark.device.modules.integration.api.service.BaseVideoService;
import com.ovopark.device.thirdparty.ovoIot.config.OvoIotConfig;
import com.ovopark.device.thirdparty.ovoIot.model.GetDataSourceBaseMo;
import com.ovopark.device.thirdparty.ovoIot.model.mms.channel.MmsCreateChannelBaseRes;
import com.ovopark.device.thirdparty.ovoIot.model.mms.channel.MmsCreateChannelInfoResWebRtc;
import com.ovopark.device.thirdparty.ovoIot.service.NvrService;
import com.ovopark.device.thirdparty.ovoIot.service.OvoVideoService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OvoVideoServiceImpl
implements BaseVideoService {
    @Autowired
    private OvoVideoService videoService;
    @Autowired
    private NvrService nvrService;
    @Autowired
    private OvoIotConfig ovoIotConfig;
    static final List<Integer> supportStartVideoPlayDtypeList = List.of(Integer.valueOf(1), Integer.valueOf(21), Integer.valueOf(22), Integer.valueOf(51));
    static final List<Integer> supportStartVideoPlayBackDtypeList = List.of(Integer.valueOf(1), Integer.valueOf(21), Integer.valueOf(22), Integer.valueOf(51));

    public List<String> getSdkNameList() {
        return null;
    }

    public BasePlayVideoRes<?> startVideoPlay(BaseVideoPlayReq<?> req) {
        List sdkNameList = req.getSdkNameList();
        Boolean mainStreamFlag = req.getMainStreamFlag();
        String serialNo = req.getSerialNo();
        Integer channelId = req.getChannelId();
        VendorVideoOvoParams vendorParams = req.getOvoVideoParams();
        Integer groupId = req.getGroupId();
        Integer depId = req.getDepId();
        String token = "3c30dad2-10f0-4b0b-9332-35fe72a9d1fa";
        boolean supportWebRtc = true;
        if (supportWebRtc && sdkNameList.contains("webRtc")) {
            return this.startVideoPlayWebRtc(req, token);
        }
        return null;
    }

    public BasePlayVideoBackRes<?> startVideoPlayBack(BaseVideoPlayBackReq req) {
        String mainSerialNo = req.getSerialNo();
        String ipcSerialNo = req.getIpcSerialNo();
        Integer channelId = req.getChannelId();
        Double plateRate = req.getPlateRate();
        String startTime = req.getStartTime();
        String endTime = req.getEndTime();
        Integer timeZone = req.getTimeZone();
        BaseVideoPlayBackReq.VendorVideoBackOvoParams vendorParams = req.getOvoVideoBackParams();
        Integer dtype = vendorParams.getDtype();
        String token = "3c30dad2-10f0-4b0b-9332-35fe72a9d1fa";
        List sdkNameList = req.getSdkNameList();
        boolean supportWebRtc = true;
        Long nowTimestamp = new Date().getTime() / 1000L;
        Long endTimeTimestamp = OvoVideoServiceImpl.convertToTimestamp(endTime);
        Long startTimeTimestamp = OvoVideoServiceImpl.convertToTimestamp(startTime);
        if (endTimeTimestamp > nowTimestamp) {
            endTimeTimestamp = nowTimestamp;
        }
        req.setStartTime(startTimeTimestamp.toString());
        req.setEndTime(endTimeTimestamp.toString());
        if (supportWebRtc && sdkNameList.contains("webRtc")) {
            return this.startVideoPlayBackWebRtc(req, token);
        }
        return null;
    }

    public static long convertToTimestamp(String dateStr) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = sdf.parse(dateStr);
            return date.getTime() / 1000L;
        }
        catch (ParseException e) {
            throw new RuntimeException("\u65e5\u671f\u8f6c\u6362\u5931\u8d25", e);
        }
    }

    private BasePlayVideoBackRes<BasePlayVideoBackRes.OvoVideoBackInfo> startVideoPlayBackWebRtc(BaseVideoPlayBackReq req, String token) {
        String serialNo = req.getSerialNo();
        Integer channelId = req.getChannelId();
        BaseVideoPlayBackReq.VendorVideoBackOvoParams ovoVideoBackParams = req.getOvoVideoBackParams();
        GetDataSourceBaseMo getDataSourceBaseMo = new GetDataSourceBaseMo();
        String realPlayWebRtcDataSource = getDataSourceBaseMo.getPlayBackWebRtcDataSource(this.ovoIotConfig.getDmsProxyUrl().replace("http://", "").replace("https://", ""), serialNo, channelId, null, ovoVideoBackParams.getNoRelay(), ovoVideoBackParams.getEnableTrickleICE(), Long.valueOf(Long.parseLong(req.getStartTime())), Long.valueOf(Long.parseLong(req.getEndTime())));
        MmsCreateChannelBaseRes channel = this.videoService.createChannel(realPlayWebRtcDataSource, token);
        MmsCreateChannelInfoResWebRtc channelinfo = channel.getChannelinfoWebRtc();
        String webrtcSignalUrl = channelinfo.getWebrtcSignalUrl();
        String webrtcSignalWss = channelinfo.getWebrtcSignalWss();
        String webrtcSignalWssPriv = channelinfo.getWebrtcSignalWssPriv();
        return BasePlayVideoBackRes.createOvoWebRtcVideo((String)webrtcSignalUrl, (String)webrtcSignalWss, (String)webrtcSignalWssPriv);
    }

    private BasePlayVideoRes startVideoPlayWebRtc(BaseVideoPlayReq req, String token) {
        Boolean mainStreamFlag = req.getMainStreamFlag();
        String serialNo = req.getSerialNo();
        Integer channelId = req.getChannelId();
        VendorVideoOvoParams vendorParams = req.getOvoVideoParams();
        GetDataSourceBaseMo getDataSourceBaseMo = new GetDataSourceBaseMo();
        String realPlayWebRtcDataSource = getDataSourceBaseMo.getRealPlayWebRtcDataSource(this.ovoIotConfig.getDmsProxyUrl().replace("http://", "").replace("https://", ""), serialNo, Integer.valueOf(mainStreamFlag != false ? 0 : 1), channelId, null, vendorParams.getNoRelay(), vendorParams.getEnableTrickleICE());
        MmsCreateChannelBaseRes channel = this.videoService.createChannel(realPlayWebRtcDataSource, token);
        MmsCreateChannelInfoResWebRtc channelinfo = channel.getChannelinfoWebRtc();
        String webrtcSignalUrl = channelinfo.getWebrtcSignalUrl();
        String webrtcSignalWss = channelinfo.getWebrtcSignalWss();
        String webrtcSignalWssPriv = channelinfo.getWebrtcSignalWssPriv();
        return BasePlayVideoRes.createOvoWebRtcVideo((String)webrtcSignalUrl, (String)webrtcSignalWss, (String)webrtcSignalWssPriv);
    }

    private BasePlayVideoRes startVideoPlayGb(BaseVideoPlayReq req, String token) {
        Boolean mainStreamFlag = req.getMainStreamFlag();
        String serialNo = req.getSerialNo();
        Integer channelId = req.getChannelId();
        VendorVideoOvoParams vendorParams = req.getOvoVideoParams();
        GetDataSourceBaseMo getDataSourceBaseMo = new GetDataSourceBaseMo();
        String realPlayWebRtcDataSource = getDataSourceBaseMo.getRealPlayWebRtcDataSource(this.ovoIotConfig.getDmsProxyUrl().replace("http://", "").replace("https://", ""), serialNo, Integer.valueOf(mainStreamFlag != false ? 0 : 1), channelId, null, vendorParams.getNoRelay(), vendorParams.getEnableTrickleICE());
        MmsCreateChannelBaseRes channel = this.videoService.createChannel(realPlayWebRtcDataSource, token);
        MmsCreateChannelInfoResWebRtc channelinfo = (MmsCreateChannelInfoResWebRtc)channel.getChannelinfo();
        String webrtcSignalUrl = channelinfo.getWebrtcSignalUrl();
        String webrtcSignalWss = channelinfo.getWebrtcSignalWss();
        String webrtcSignalWssPriv = channelinfo.getWebrtcSignalWssPriv();
        return BasePlayVideoRes.createOvoWebRtcVideo((String)webrtcSignalUrl, (String)webrtcSignalWss, (String)webrtcSignalWssPriv);
    }

    public String getVendorType() {
        return IntegrationEnum.Ovo.getType();
    }
}

