/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.integration.ovo.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.device.cloud.api.VideoFeignService;
import com.ovopark.device.common.response.BaseResult;
import com.ovopark.device.modules.integration.api.model.req.BaseVideoPlayBackReq;
import com.ovopark.device.modules.integration.api.model.res.BasePlayVideoBackRes;
import com.ovopark.device.modules.integration.ovo.impl.CouldWatchService;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.DeviceStatusMapper;
import com.ovopark.device.sdk.common.model.mo.CloudWatchPlayAudioMo;
import com.ovopark.device.sdk.common.model.mo.SwitchStateMo;
import com.ovopark.device.sdk.common.model.vo.CloudWatchVoiceCallVo;
import com.ovopark.device.sdk.common.model.vo.GetYzsDeviceStatusByMac;
import com.ovopark.device.thirdparty.ovoIot.config.OvoIotConfig;
import com.ovopark.device.thirdparty.ovoIot.model.GeneralDataStatusRes;
import com.ovopark.device.thirdparty.ovoIot.model.GetDataSourceBaseMo;
import com.ovopark.device.thirdparty.ovoIot.model.GetDoorLockStateRes;
import com.ovopark.device.thirdparty.ovoIot.model.GetSwitchStateRes;
import com.ovopark.device.thirdparty.ovoIot.model.SetDoorLockStateRes;
import com.ovopark.device.thirdparty.ovoIot.model.StartVideoCallRes;
import com.ovopark.device.thirdparty.ovoIot.model.common.CommonException;
import com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum;
import com.ovopark.device.thirdparty.ovoIot.model.mms.channel.MmsCreateChannelBaseRes;
import com.ovopark.device.thirdparty.ovoIot.model.mms.channel.MmsCreateChannelInfoResWebRtc;
import com.ovopark.device.thirdparty.ovoIot.model.req.CloudWatchPlayAudioReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.DoorLockStateReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetCloudGuardEventCBReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetCloudGuardStateReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetSwitchStateReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.SetWelcomeVideoReq;
import com.ovopark.device.thirdparty.ovoIot.model.req.StartVideoCallReq;
import com.ovopark.device.thirdparty.ovoIot.service.NvrService;
import com.ovopark.device.thirdparty.ovoIot.service.OvoVideoService;
import com.ovopark.device.thirdparty.ovoIot.util.AbilityUtil;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import jakarta.annotation.Resource;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class CouldWatchServiceImpl
implements CouldWatchService {
    private static final Logger log = LoggerFactory.getLogger(CouldWatchServiceImpl.class);
    @Autowired
    private NvrService nvrService;
    @Autowired
    private DeviceStatusMapper deviceStatusMapper;
    @Autowired
    private OvoVideoService videoService;
    @Autowired
    private OvoIotConfig ovoIotConfig;
    @Resource
    private DeviceStatusService deviceStatusService;
    @Resource
    private VideoFeignService videoFeignService;
    @Value(value="${yzs.event-url:#{null}}")
    private String eventUrl;
    @Resource
    private DepartmentApi departmentApi;

    private DeviceStatus getDeviceMacByDepId(Integer depId) {
        List deviceStatuses = this.deviceStatusService.listDevice(depId);
        if (CollectionUtils.isEmpty((Collection)deviceStatuses)) {
            return null;
        }
        for (DeviceStatus deviceStatus : deviceStatuses) {
            if (deviceStatus.getDType() == null || 20 != deviceStatus.getDType() || !org.apache.commons.lang3.StringUtils.equalsIgnoreCase((CharSequence)"Dolphin1-C", (CharSequence)deviceStatus.getDeviceType())) continue;
            return deviceStatus;
        }
        return null;
    }

    @Override
    public GetDoorLockStateRes getDoorLockState(Integer depId) {
        DeviceStatus deviceStatus = this.getDeviceMacByDepId(depId);
        if (deviceStatus == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        if (!CouldWatchServiceImpl.supportWatch(deviceStatus.getExtendCapacity(), 84)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        GetDoorLockStateRes doorLockState = this.nvrService.getDoorLockState(deviceStatus.getMac());
        if (doorLockState != null && !"comm_success".equals(doorLockState.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return doorLockState;
    }

    @Override
    public com.ovopark.module.shared.BaseResult setDoorLockState(Integer depId, String state, Integer id, Integer unlock_duration, String direction) {
        DeviceStatus deviceStatus = this.getDeviceMacByDepId(depId);
        if (deviceStatus == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        DoorLockStateReq stateReq = new DoorLockStateReq();
        stateReq.setState(state);
        stateReq.setId(id);
        if (unlock_duration != null) {
            stateReq.setUnlock_duration(unlock_duration);
        }
        stateReq.setDirection(direction);
        if (!CouldWatchServiceImpl.supportWatch(deviceStatus.getExtendCapacity(), 84)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        SetDoorLockStateRes doorLockState = this.nvrService.setDoorLockState(deviceStatus.getMac(), stateReq);
        if (doorLockState != null && !"comm_success".equals(doorLockState.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }

    public com.ovopark.module.shared.BaseResult<CloudWatchVoiceCallVo> cloudWatchVoiceCall(Integer depId, Integer deviceId) {
        String token = null;
        BaseVideoPlayBackReq req = new BaseVideoPlayBackReq();
        DeviceStatus deviceStatus = this.getDeviceMacByDepId(depId);
        if (deviceStatus == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        req.setSerialNo(deviceStatus.getMac());
        req.setChannelId(deviceStatus.getChannelId());
        token = this.getToken(deviceStatus.getGroupId(), deviceStatus.getDepId(), 1);
        if (token == null) {
            log.info("cloudWatchVoiceCall\u83b7\u53d6\u4f01\u4e1a\u64ad\u653etoken\u5931\u8d25\uff1a{}", (Object)token);
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        boolean supportASyncCloudWatchVoiceCall = false;
        if (CouldWatchServiceImpl.supportWatch(deviceStatus.getExtendCapacity(), 97)) {
            supportASyncCloudWatchVoiceCall = true;
        }
        BasePlayVideoBackRes<BasePlayVideoBackRes.OvoVideoBackInfo> ovoVideoBackInfoBasePlayVideoBackRes = this.cloudWatchVoiceCall(req, token);
        CloudWatchVoiceCallVo cloudWatchVoiceCallVo = new CloudWatchVoiceCallVo();
        cloudWatchVoiceCallVo.setWebrtcSignalWss(ovoVideoBackInfoBasePlayVideoBackRes.getOvoVideoBackInfo().getWebrtcSignalWss());
        cloudWatchVoiceCallVo.setWebrtcSignalWssPriv(ovoVideoBackInfoBasePlayVideoBackRes.getOvoVideoBackInfo().getWebrtcSignalWssPriv());
        cloudWatchVoiceCallVo.setSupportASyncCloudWatchVoiceCall(supportASyncCloudWatchVoiceCall);
        return com.ovopark.module.shared.BaseResult.success((Object)cloudWatchVoiceCallVo);
    }

    private BasePlayVideoBackRes<BasePlayVideoBackRes.OvoVideoBackInfo> cloudWatchVoiceCall(BaseVideoPlayBackReq req, String token) {
        String serialNo = req.getSerialNo();
        Integer channelId = req.getChannelId();
        GetDataSourceBaseMo getDataSourceBaseMo = new GetDataSourceBaseMo();
        String realPlayWebRtcDataSource = getDataSourceBaseMo.cloudWatchVoiceCall(this.ovoIotConfig.getDmsProxyUrl().replace("http://", "").replace("https://", ""), serialNo, channelId, Boolean.valueOf(true), Integer.valueOf(0), Boolean.valueOf(true));
        log.info("cloudWatchVoiceCall\u521b\u5efawebrtc\u6570\u636e\u6e90\uff1a{}", (Object)realPlayWebRtcDataSource);
        MmsCreateChannelBaseRes channel = this.videoService.createChannel(realPlayWebRtcDataSource, token);
        log.info("cloudWatchVoiceCall\u521b\u5efawebrtc\u901a\u9053\u8fd4\u56de\uff1a{}", (Object)channel);
        MmsCreateChannelInfoResWebRtc channelinfo = channel.getChannelinfoWebRtc();
        String webrtcSignalUrl = channelinfo.getWebrtcSignalUrl();
        String webrtcSignalWss = channelinfo.getWebrtcSignalWss();
        String webrtcSignalWssPriv = channelinfo.getWebrtcSignalWssPriv();
        return BasePlayVideoBackRes.createOvoWebRtcVideo((String)webrtcSignalUrl, (String)webrtcSignalWss, (String)webrtcSignalWssPriv, null);
    }

    @Override
    public com.ovopark.module.shared.BaseResult cloudWatchPlayAudio(Integer depId, CloudWatchPlayAudioReq req) {
        DeviceStatus deviceStatus = this.getDeviceMacByDepId(depId);
        if (deviceStatus == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        if (!CouldWatchServiceImpl.supportWatch(deviceStatus.getExtendCapacity(), 86)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        GeneralDataStatusRes generalDataStatusRes = this.nvrService.cloudWatchPlayAudio(deviceStatus.getMac(), req);
        if (generalDataStatusRes != null && !"comm_success".equals(generalDataStatusRes.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }

    @Override
    public GetYzsDeviceStatusByMac getYzsDeviceStatusByMac(String mac) {
        GetYzsDeviceStatusByMac deviceStatusByMac = new GetYzsDeviceStatusByMac();
        LambdaQueryWrapper eq = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceStatus::getIsDelete, (Object)0)).eq(DeviceStatus::getMac, (Object)mac)).eq(DeviceStatus::getDType, (Object)240);
        List deviceStatuses = this.deviceStatusMapper.selectList((Wrapper)eq);
        if (!CollectionUtils.isEmpty((Collection)deviceStatuses) && deviceStatuses.size() > 0) {
            DeviceStatus deviceStatus = (DeviceStatus)deviceStatuses.get(0);
            try {
                com.ovopark.organize.common.base.BaseResult departmentById = this.departmentApi.getDepartmentById(deviceStatus.getDepId());
                deviceStatusByMac.setDepName(((DepartmentPojo)departmentById.getData()).getName());
            }
            catch (Exception e) {
                log.error("getYzsDeviceStatusByMac\u83b7\u53d6\u90e8\u95e8\u4fe1\u606f\u5931\u8d25\uff1a{}", (Throwable)e);
            }
            deviceStatusByMac.setMac(deviceStatus.getMac());
            deviceStatusByMac.setDeviceName(deviceStatus.getDeviceName());
            deviceStatusByMac.setDepId(deviceStatus.getDepId());
            deviceStatusByMac.setEnterpriseId(deviceStatus.getGroupId());
        }
        return deviceStatusByMac;
    }

    @Override
    public com.ovopark.module.shared.BaseResult startVideoCall(Integer depId, String url) {
        DeviceStatus deviceStatus = this.getDeviceMacByDepId(depId);
        if (deviceStatus == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        if (!CouldWatchServiceImpl.supportWatch(deviceStatus.getExtendCapacity(), 85)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        StartVideoCallReq stateReq = new StartVideoCallReq();
        stateReq.setUrl(url);
        StartVideoCallRes doorLockState = this.nvrService.startVideoCall(deviceStatus.getMac(), stateReq);
        if (doorLockState != null && !"comm_success".equals(doorLockState.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }

    @Override
    public com.ovopark.module.shared.BaseResult stopVideoCall(Integer depId) {
        DeviceStatus deviceStatus = this.getDeviceMacByDepId(depId);
        if (deviceStatus == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        if (!CouldWatchServiceImpl.supportWatch(deviceStatus.getExtendCapacity(), 85)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        StartVideoCallRes doorLockState = this.nvrService.stopVideoCall(deviceStatus.getMac(), null);
        if (doorLockState != null && !"comm_success".equals(doorLockState.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }

    private String getToken(Integer enterpriseId, Integer deptId, Integer groupType) {
        BaseResult tokenByDeptId = this.videoFeignService.getTokenByDeptId(enterpriseId, deptId, groupType);
        return (String)tokenByDeptId.getData();
    }

    @Override
    public com.ovopark.module.shared.BaseResult setCloudGuardEventCB(Integer nvrId) {
        DeviceStatus nvr = this.deviceStatusService.getById(nvrId);
        if (nvr == null || nvr.getIsDelete() == 1) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        if (!CouldWatchServiceImpl.supportWatch(nvr.getExtendCapacity(), 87)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        SetCloudGuardEventCBReq req = new SetCloudGuardEventCBReq();
        req.setDepId(nvr.getDepId());
        req.setEventType(Arrays.asList(1));
        req.setUrl(this.eventUrl);
        GeneralDataStatusRes generalDataStatusRes = this.nvrService.setCloudGuardEventCB(nvr.getMac(), req);
        if (generalDataStatusRes != null && !"comm_success".equals(generalDataStatusRes.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }

    @Override
    public com.ovopark.module.shared.BaseResult setWelcomeVideo(Integer nvrId, String url) {
        DeviceStatus nvr = this.deviceStatusService.getById(nvrId);
        if (nvr == null || nvr.getIsDelete() == 1) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        if (!CouldWatchServiceImpl.supportWatch(nvr.getExtendCapacity(), 88)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        SetWelcomeVideoReq req = new SetWelcomeVideoReq();
        req.setUrl(url);
        req.setEnbale(Boolean.valueOf(true));
        GeneralDataStatusRes generalDataStatusRes = this.nvrService.setWelcomeVideo(nvr.getMac(), req);
        if (generalDataStatusRes != null && !"comm_success".equals(generalDataStatusRes.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }

    @Override
    public com.ovopark.module.shared.BaseResult setCloudGuardState(Integer depId, String state, Integer doorType) {
        DeviceStatus deviceStatus = this.getDeviceMacByDepId(depId);
        if (deviceStatus == null) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        if (!CouldWatchServiceImpl.supportWatch(deviceStatus.getExtendCapacity(), 90)) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        SetCloudGuardStateReq req = new SetCloudGuardStateReq();
        req.setState(state);
        req.setDoorType(Integer.valueOf(doorType == null ? 0 : doorType));
        GeneralDataStatusRes generalDataStatusRes = this.nvrService.setCloudGuardState(deviceStatus.getMac(), req);
        if (generalDataStatusRes != null && !"comm_success".equals(generalDataStatusRes.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }

    public static boolean supportWatch(String capacity, Integer places) {
        int support;
        return org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)capacity) && capacity.length() > places && (support = Integer.parseInt(capacity.substring(places - 1, places))) == 1;
    }

    @Override
    public com.ovopark.module.shared.BaseResult cloudWatchPlayAudioConvert(CloudWatchPlayAudioMo cloudWatchPlayAudioMo) {
        String md5 = null;
        try {
            md5 = CouldWatchServiceImpl.getAudioMD5FromUrl(cloudWatchPlayAudioMo.getUrl());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u97f3\u9891md5\u5931\u8d25", (Throwable)e);
        }
        if (StringUtils.isEmpty((Object)md5)) {
            return com.ovopark.module.shared.BaseResult.error((Object)"\u97f3\u9891md5\u4e3a\u7a7a");
        }
        CloudWatchPlayAudioReq req = new CloudWatchPlayAudioReq();
        req.setUrl(cloudWatchPlayAudioMo.getUrl());
        req.setMd5(md5);
        req.setName((String)(!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)cloudWatchPlayAudioMo.getName()) ? cloudWatchPlayAudioMo.getName() : UUID.randomUUID().toString() + "." + CouldWatchServiceImpl.getExtension(cloudWatchPlayAudioMo.getUrl())));
        req.setAudio_cards(cloudWatchPlayAudioMo.getAudio_cards());
        if (cloudWatchPlayAudioMo.getRepeat() != null) {
            req.setRepeat(cloudWatchPlayAudioMo.getRepeat());
            req.setStop(cloudWatchPlayAudioMo.isStop());
        }
        return this.cloudWatchPlayAudio(cloudWatchPlayAudioMo.getDepId(), req);
    }

    public static String getExtension(String url) {
        return url.substring(url.lastIndexOf(46) + 1);
    }

    public static String getAudioMD5FromUrl(String audioUrl) throws Exception {
        HttpURLConnection conn = (HttpURLConnection)new URL(audioUrl).openConnection();
        conn.setConnectTimeout(5000);
        conn.setRequestProperty("User-Agent", "Mozilla/5.0");
        try (InputStream is = conn.getInputStream();){
            int read;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            while ((read = is.read(buffer)) > 0) {
                md.update(buffer, 0, read);
            }
            byte[] md5Bytes = md.digest();
            StringBuilder sb = new StringBuilder();
            for (byte b : md5Bytes) {
                sb.append(String.format("%02x", b));
            }
            String string = sb.toString();
            return string;
        }
    }

    @Override
    public com.ovopark.module.shared.BaseResult playAlarm(CloudWatchPlayAudioMo cloudWatchPlayAudioMo) {
        CloudWatchPlayAudioReq req = new CloudWatchPlayAudioReq();
        req.setUrl("https://ovopark-oss-default.oss-cn-hangzhou.aliyuncs.com/cloud-watch/211/2025/08/08/alarm.mp3");
        req.setMd5("81b86a27692d30a36083796f18940443");
        req.setName("14a78386-7aa6-45d8-acbf-e739b91e4057.mp3");
        req.setAudio_cards(cloudWatchPlayAudioMo.getAudio_cards());
        if (cloudWatchPlayAudioMo.getRepeat() != null) {
            req.setRepeat(cloudWatchPlayAudioMo.getRepeat());
            req.setStop(cloudWatchPlayAudioMo.isStop());
        }
        return this.cloudWatchPlayAudio(cloudWatchPlayAudioMo.getDepId(), req);
    }

    @Override
    public com.ovopark.module.shared.BaseResult getSwitchState(Integer nvrId) {
        DeviceStatus nvr = this.deviceStatusService.getById(nvrId);
        if (nvr == null || nvr.getIsDelete() == 1) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        boolean support = AbilityUtil.supportSwitch((Integer)nvr.getDType(), (String)nvr.getExtendCapacity());
        if (!support) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        GetSwitchStateRes getSwitchStateRes = this.nvrService.getSwitchState(nvr.getMac());
        if (getSwitchStateRes != null && !"comm_success".equals(getSwitchStateRes.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success((Object)getSwitchStateRes.getData());
    }

    @Override
    public com.ovopark.module.shared.BaseResult setSwitchState(SwitchStateMo switchStateMo) {
        DeviceStatus nvr = this.deviceStatusService.getById(switchStateMo.getDeviceStatusId());
        if (nvr == null || nvr.getIsDelete() == 1) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_EXIST);
        }
        boolean support = AbilityUtil.supportSwitch((Integer)nvr.getDType(), (String)nvr.getExtendCapacity());
        if (!support) {
            throw new CommonException(ExceptionEnum.DEVICE_NOT_SUPPORTED);
        }
        SetSwitchStateReq req = new SetSwitchStateReq();
        req.setState(switchStateMo.getState());
        req.setId(switchStateMo.getId());
        req.setUnlock_duration(switchStateMo.getUnlock_duration());
        req.setDirection(switchStateMo.getDirection());
        GeneralDataStatusRes generalDataStatusRes = this.nvrService.setSwitchState(nvr.getMac(), req);
        if (generalDataStatusRes != null && !"comm_success".equals(generalDataStatusRes.getStatus())) {
            throw new CommonException(ExceptionEnum.DEVICE_ERROR);
        }
        return com.ovopark.module.shared.BaseResult.success(null);
    }
}

