/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.integration.ovo.impl;

import com.ovopark.device.modules.integration.api.enums.IntegrationEnum;
import com.ovopark.device.modules.integration.api.model.req.BaseVideoPlayBackReq;
import com.ovopark.device.modules.integration.api.model.req.BaseVideoPlayReq;
import com.ovopark.device.modules.integration.api.model.req.VendorVideoOvoParams;
import com.ovopark.device.modules.integration.api.model.res.BasePlayVideoBackRes;
import com.ovopark.device.modules.integration.api.model.res.BasePlayVideoRes;
import com.ovopark.device.modules.integration.api.service.BaseVideoService;
import com.ovopark.device.thirdparty.ovoIot.config.OvoIotConfig;
import com.ovopark.device.thirdparty.ovoIot.model.GetDataSourceBaseMo;
import com.ovopark.device.thirdparty.ovoIot.model.common.CommonException;
import com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum;
import com.ovopark.device.thirdparty.ovoIot.model.mms.channel.MmsCreateChannelBaseRes;
import com.ovopark.device.thirdparty.ovoIot.model.mms.channel.MmsCreateChannelInfoResWebRtc;
import com.ovopark.device.thirdparty.ovoIot.service.NvrService;
import com.ovopark.device.thirdparty.ovoIot.service.OvoVideoService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OvoVideoServiceImpl
implements BaseVideoService {
    @Autowired
    private OvoVideoService videoService;
    @Autowired
    private NvrService nvrService;
    @Autowired
    private OvoIotConfig ovoIotConfig;
    static final List<Integer> supportStartVideoPlayDtypeList = List.of(Integer.valueOf(1), Integer.valueOf(21), Integer.valueOf(22), Integer.valueOf(51));
    static final List<Integer> supportStartVideoPlayBackDtypeList = List.of(Integer.valueOf(1), Integer.valueOf(21), Integer.valueOf(22), Integer.valueOf(51));

    public List<String> getSdkNameList() {
        return null;
    }

    public BasePlayVideoRes<?> startVideoPlay(BaseVideoPlayReq<?> req) {
        List sdkNameList = req.getSdkNameList();
        Boolean mainStreamFlag = req.getMainStreamFlag();
        String serialNo = req.getSerialNo();
        Integer channelId = req.getChannelId();
        VendorVideoOvoParams vendorParams = req.getOvoVideoParams();
        Integer groupId = req.getGroupId();
        Integer depId = req.getDepId();
        String token = vendorParams.getToken();
        boolean supportWebRtc = true;
        if (supportWebRtc && sdkNameList.contains("webRtc")) {
            return this.startVideoPlayWebRtc(req, token);
        }
        return null;
    }

    public BasePlayVideoBackRes<?> startVideoPlayBack(BaseVideoPlayBackReq req) {
        String mainSerialNo = req.getSerialNo();
        String ipcSerialNo = req.getIpcSerialNo();
        Integer channelId = req.getChannelId();
        Double playrate = req.getPlayrate();
        String startTime = req.getStartTime();
        String endTime = req.getEndTime();
        Integer timeZone = req.getTimeZone();
        BaseVideoPlayBackReq.VendorVideoBackOvoParams vendorParams = req.getOvoVideoBackParams();
        Integer dtype = vendorParams.getDtype();
        List sdkNameList = req.getSdkNameList();
        boolean supportWebRtc = true;
        Long nowTimestamp = new Date().getTime();
        Long endTimeTimestamp = OvoVideoServiceImpl.convertToTimestamp(endTime);
        Long startTimeTimestamp = OvoVideoServiceImpl.convertToTimestamp(startTime);
        if (endTimeTimestamp > nowTimestamp) {
            endTimeTimestamp = nowTimestamp;
        }
        req.setStartTime(startTimeTimestamp.toString());
        req.setEndTime(endTimeTimestamp.toString());
        req.setPlayrate(playrate);
        if (supportWebRtc && sdkNameList.contains("webRtc")) {
            return this.startVideoPlayBackWebRtc(req, vendorParams.getToken());
        }
        return null;
    }

    public static long convertToTimestamp(String dateStr) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = sdf.parse(dateStr);
            return date.getTime();
        }
        catch (ParseException e) {
            throw new RuntimeException("\u65e5\u671f\u8f6c\u6362\u5931\u8d25", e);
        }
    }

    private BasePlayVideoBackRes<BasePlayVideoBackRes.OvoVideoBackInfo> startVideoPlayBackWebRtc(BaseVideoPlayBackReq req, String token) {
        String serialNo = req.getSerialNo();
        Integer channelId = req.getChannelId();
        BaseVideoPlayBackReq.VendorVideoBackOvoParams ovoVideoBackParams = req.getOvoVideoBackParams();
        GetDataSourceBaseMo getDataSourceBaseMo = new GetDataSourceBaseMo();
        String realPlayWebRtcDataSource = getDataSourceBaseMo.getPlayBackWebRtcDataSource(this.ovoIotConfig.getDmsProxyUrl().replace("http://", "").replace("https://", ""), serialNo, channelId, null, ovoVideoBackParams.getNoRelay(), ovoVideoBackParams.getEnableTrickleICE(), Long.valueOf(Long.parseLong(req.getStartTime())), Long.valueOf(Long.parseLong(req.getEndTime())), req.getPlayrate());
        MmsCreateChannelBaseRes channel = this.videoService.createChannel(realPlayWebRtcDataSource, token);
        MmsCreateChannelInfoResWebRtc channelinfo = channel.getChannelinfoWebRtc();
        if (channelinfo == null) {
            throw new CommonException(ExceptionEnum.MMS_ERROR_COMMON, channel.getErrno());
        }
        String webrtcSignalUrl = channelinfo.getWebrtcSignalUrl();
        String webrtcSignalWss = channelinfo.getWebrtcSignalWss();
        String webrtcSignalWssPriv = channelinfo.getWebrtcSignalWssPriv();
        MmsCreateChannelInfoResWebRtc.TurnInfo turnInfo = channelinfo.getTurnInfo();
        BasePlayVideoRes.OvoVideoInfo.TurnInfo turnInfo1 = new BasePlayVideoRes.OvoVideoInfo.TurnInfo();
        if (turnInfo != null) {
            turnInfo1.setIceServer(turnInfo.getIceServer());
            turnInfo1.setUsername(turnInfo.getUsername());
            turnInfo1.setCredential(turnInfo.getCredential());
        }
        return BasePlayVideoBackRes.createOvoWebRtcVideo((String)webrtcSignalUrl, (String)webrtcSignalWss, (String)webrtcSignalWssPriv, (BasePlayVideoRes.OvoVideoInfo.TurnInfo)(turnInfo != null ? turnInfo1 : null));
    }

    private BasePlayVideoRes startVideoPlayWebRtc(BaseVideoPlayReq req, String token) {
        Boolean mainStreamFlag = req.getMainStreamFlag();
        String serialNo = req.getSerialNo();
        Integer channelId = req.getChannelId();
        VendorVideoOvoParams vendorParams = req.getOvoVideoParams();
        GetDataSourceBaseMo getDataSourceBaseMo = new GetDataSourceBaseMo();
        Boolean videoTrackPause = vendorParams.getVideoTrackPause();
        Boolean audioTrackPause = vendorParams.getAudioTrackPause();
        String realPlayWebRtcDataSource = getDataSourceBaseMo.getRealPlayWebRtcDataSource(this.ovoIotConfig.getDmsProxyUrl().replace("http://", "").replace("https://", ""), serialNo, Integer.valueOf(mainStreamFlag != false ? 0 : 1), channelId, null, vendorParams.getNoRelay(), vendorParams.getEnableTrickleICE(), videoTrackPause, audioTrackPause);
        MmsCreateChannelBaseRes channel = this.videoService.createChannel(realPlayWebRtcDataSource, token);
        MmsCreateChannelInfoResWebRtc channelinfo = channel.getChannelinfoWebRtc();
        String webrtcSignalUrl = channelinfo.getWebrtcSignalUrl();
        String webrtcSignalWss = channelinfo.getWebrtcSignalWss();
        String webrtcSignalWssPriv = channelinfo.getWebrtcSignalWssPriv();
        MmsCreateChannelInfoResWebRtc.TurnInfo turnInfo = channelinfo.getTurnInfo();
        BasePlayVideoRes.OvoVideoInfo.TurnInfo turnInfo1 = new BasePlayVideoRes.OvoVideoInfo.TurnInfo();
        if (turnInfo != null) {
            turnInfo1.setIceServer(turnInfo.getIceServer());
            turnInfo1.setUsername(turnInfo.getUsername());
            turnInfo1.setCredential(turnInfo.getCredential());
        }
        return BasePlayVideoRes.createOvoWebRtcVideo((String)webrtcSignalUrl, (String)webrtcSignalWss, (String)webrtcSignalWssPriv, (BasePlayVideoRes.OvoVideoInfo.TurnInfo)(turnInfo != null ? turnInfo1 : null));
    }

    private BasePlayVideoRes startVideoPlayGb(BaseVideoPlayReq req, String token) {
        Boolean mainStreamFlag = req.getMainStreamFlag();
        String serialNo = req.getSerialNo();
        Integer channelId = req.getChannelId();
        VendorVideoOvoParams vendorParams = req.getOvoVideoParams();
        Boolean videoTrackPause = vendorParams.getVideoTrackPause();
        Boolean audioTrackPause = vendorParams.getAudioTrackPause();
        GetDataSourceBaseMo getDataSourceBaseMo = new GetDataSourceBaseMo();
        String realPlayWebRtcDataSource = getDataSourceBaseMo.getRealPlayWebRtcDataSource(this.ovoIotConfig.getDmsProxyUrl().replace("http://", "").replace("https://", ""), serialNo, Integer.valueOf(mainStreamFlag != false ? 0 : 1), channelId, null, vendorParams.getNoRelay(), vendorParams.getEnableTrickleICE(), videoTrackPause, audioTrackPause);
        MmsCreateChannelBaseRes channel = this.videoService.createChannel(realPlayWebRtcDataSource, token);
        MmsCreateChannelInfoResWebRtc channelinfo = (MmsCreateChannelInfoResWebRtc)channel.getChannelinfo();
        String webrtcSignalUrl = channelinfo.getWebrtcSignalUrl();
        String webrtcSignalWss = channelinfo.getWebrtcSignalWss();
        String webrtcSignalWssPriv = channelinfo.getWebrtcSignalWssPriv();
        MmsCreateChannelInfoResWebRtc.TurnInfo turnInfo = channelinfo.getTurnInfo();
        BasePlayVideoRes.OvoVideoInfo.TurnInfo turnInfo1 = new BasePlayVideoRes.OvoVideoInfo.TurnInfo();
        if (turnInfo != null) {
            turnInfo1.setIceServer(turnInfo.getIceServer());
            turnInfo1.setUsername(turnInfo.getUsername());
            turnInfo1.setCredential(turnInfo.getCredential());
        }
        return BasePlayVideoRes.createOvoWebRtcVideo((String)webrtcSignalUrl, (String)webrtcSignalWss, (String)webrtcSignalWssPriv, (BasePlayVideoRes.OvoVideoInfo.TurnInfo)(turnInfo != null ? turnInfo1 : null));
    }

    public String getVendorType() {
        return IntegrationEnum.Ovo.getType();
    }
}

