/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.job;

import com.ovopark.device.modules.job.ScheduledTask;
import com.ovopark.device.platform.api.JobFacade;
import com.ovopark.device.platform.api.job.ScheduledTaskRequest;
import com.ovopark.device.platform.api.job.ScheduledTaskResponse;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.es7x.Document;
import com.ovopark.module.shared.es7x.ElasticsearchOperations;
import jakarta.annotation.Resource;
import java.util.HashMap;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.springframework.stereotype.Component;

@Component
public class JobFacadeImpl
implements JobFacade {
    @Resource
    private ElasticsearchOperations elasticsearchOperations;

    public ScheduledTaskResponse insert(ScheduledTaskRequest scheduledTaskRequest) {
        ScheduledTask scheduledTask = new ScheduledTask();
        if (Util.isNotEmpty((CharSequence)scheduledTaskRequest.getId())) {
            scheduledTask.setId(scheduledTaskRequest.getId());
        }
        scheduledTask.setTaskData(scheduledTaskRequest.getTaskData());
        this.elasticsearchOperations.save("device-scheduled-task", (Document)scheduledTask);
        ScheduledTaskResponse scheduledTaskResponse = new ScheduledTaskResponse();
        scheduledTaskResponse.setId(scheduledTask.id());
        scheduledTaskResponse.setSuccess(true);
        return scheduledTaskResponse;
    }

    public void updateAsError(String id, String errorMsg) {
        this.elasticsearchOperations.updatePartOfDoc("device-scheduled-task", id, () -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("status", -1);
            params.put("errorMsg", errorMsg);
            Script script = new Script(ScriptType.INLINE, "painless", "ctx._source.status=params['status'];ctx._source.errorMsg=params['errorMsg'];", params);
            return script;
        });
    }

    public void updateAsSuccess(String id) {
        this.elasticsearchOperations.updatePartOfDoc("device-scheduled-task", id, () -> {
            HashMap<String, Integer> params = new HashMap<String, Integer>();
            params.put("status", 1);
            Script script = new Script(ScriptType.INLINE, "painless", "ctx._source.status=params['status'];", params);
            return script;
        });
    }

    public void cancel(String id, String cancelMsg) {
        this.elasticsearchOperations.updatePartOfDoc("device-scheduled-task", id, () -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("status", 2);
            params.put("errorMsg", cancelMsg);
            Script script = new Script(ScriptType.INLINE, "painless", "ctx._source.status=params['status'];ctx._source.errorMsg=params['errorMsg'];", params);
            return script;
        });
    }
}

