/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.job;

import com.ovopark.device.modules.job.ScheduledTask;
import com.ovopark.device.modules.platform.ConditionOnKafka;
import com.ovopark.device.platform.api.job.JobLog;
import com.ovopark.device.platform.api.job.JobTaskExecutor;
import com.ovopark.device.platform.api.job.ScheduledTaskExecution;
import com.ovopark.kernel.shared.JSONAccessor;
import java.util.List;
import java.util.function.Supplier;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@ConditionOnKafka
@Component
public class JobKafkaInStream {
    private static final Logger log = LoggerFactory.getLogger(JobKafkaInStream.class);
    private List<JobTaskExecutor> jobTaskExecutorList;

    @Autowired
    public void setTaskExecutorList(List<JobTaskExecutor> jobTaskExecutorList) {
        this.jobTaskExecutorList = jobTaskExecutorList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @KafkaListener(concurrency="${messagehub.control.sdk.kafka.concurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="device-scheduled-task", groupId="${device.videoReport.kafka.group:deviceScheduledTask}", containerFactory="deviceKafkaMainContainerFactory", id="device-scheduled-task")
    public void scheduledTask(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset);
        Object value = record.value();
        ScheduledTask scheduledTask = (ScheduledTask)JSONAccessor.impl().read((String)value, ScheduledTask.class);
        MDC.put((String)"traceId", (String)scheduledTask.getId());
        MDC.put((String)"requestId", (String)("device-" + scheduledTask.getType() + "-" + scheduledTask.id()));
        log.info("scheduled task from SDK KAFKA: " + String.valueOf(value));
        try {
            JobLog jobLog = new JobLog(this){

                public void log(String content) {
                }

                public void log(Supplier<String> content) {
                }

                public void flush() {
                }

                public void flush(boolean sync) {
                }

                public void close() {
                }
            };
            for (JobTaskExecutor jobTaskExecutor : this.jobTaskExecutorList) {
                ScheduledTaskExecution scheduledTaskExecution = new ScheduledTaskExecution();
                scheduledTaskExecution.setId(scheduledTask.getId());
                scheduledTaskExecution.setTaskData(scheduledTask.getTaskData());
                scheduledTaskExecution.setType(scheduledTask.getType());
                scheduledTaskExecution.setGroup(scheduledTask.getGroup());
                if (!jobTaskExecutor.accept(scheduledTaskExecution, jobLog)) continue;
                jobTaskExecutor.execute(scheduledTaskExecution, jobLog);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            MDC.remove((String)"requestId");
            MDC.remove((String)"traceId");
        }
    }
}

