/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.manage.tokenflow;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.device.modules.manage.mysql.GroupGprsLicenceMapper;
import com.ovopark.device.modules.manage.mysql.GroupOrgGprsLicenceMapper;
import com.ovopark.device.modules.manage.mysql.GroupOrgGprsLicenses;
import com.ovopark.device.modules.manage.mysql.LocalDayChannelInfoEsSumMapper;
import com.ovopark.device.modules.manage.tokenflow.EnterpriseFlowQuery;
import com.ovopark.device.modules.manage.tokenflow.EnterpriseFlowVo;
import com.ovopark.device.modules.manage.tokenflow.FlowStatService;
import com.ovopark.device.modules.manage.tokenflow.GroupFlowVo;
import com.ovopark.device.modules.manage.tokenflow.OrgInfo;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.device.platform.api.RPCFacade;
import com.ovopark.device.thirdparty.ovoIot.model.mms.GoldLicensesRes;
import com.ovopark.device.thirdparty.ovoIot.model.mms.MmsBaseRes;
import com.ovopark.device.thirdparty.ovoIot.service.MmsService;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.PageModel;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.EnterpriseGroupMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.OrganizePojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.OrganizeApi;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowStatServiceImpl
implements FlowStatService {
    @Autowired
    private LocalDayChannelInfoEsSumMapper localDayChannelInfoEsSumMapper;
    @Autowired
    private RPCFacade rpcFacade;
    @Autowired
    private MmsService mmsService;
    @Autowired
    private GroupGprsLicenceMapper groupGprsLicenceMapper;
    @Autowired
    private GroupOrgGprsLicenceMapper groupOrgGprsLicenceMapper;
    @Autowired
    private DepartmentFacade departmentFacade;
    @Resource
    private DepartmentApi departmentApi;
    @Resource
    private OrganizeApi organizeApi;

    @Override
    public PageModel<EnterpriseFlowVo> groupFlow(EnterpriseFlowQuery enterpriseFlowQuery) {
        Page page = new Page();
        long pageNumber = enterpriseFlowQuery.getPageNumber();
        page.setCurrent(pageNumber);
        int pageSize = enterpriseFlowQuery.getPageSize();
        page.setSize((long)pageSize);
        IPage<EnterpriseFlowVo> groupFlowVoIPage = this.localDayChannelInfoEsSumMapper.queryPage((Page<EnterpriseFlowVo>)page, enterpriseFlowQuery.getStartTime(), enterpriseFlowQuery.getEndTime());
        if (Util.isEmpty((Collection)groupFlowVoIPage.getRecords())) {
            return PageModel.from((long)pageNumber, (int)pageSize, (long)0L, null);
        }
        List<Integer> list = groupFlowVoIPage.getRecords().stream().map(EnterpriseFlowVo::getEnterpriseId).toList();
        List enterpriseGroupMoList = this.rpcFacade.enterpriseList(list);
        Map<Integer, EnterpriseGroupMo> enterpriseGroupMoMap = enterpriseGroupMoList.stream().collect(Collectors.toMap(EnterpriseGroupMo::getId, v -> v));
        for (EnterpriseFlowVo record : groupFlowVoIPage.getRecords()) {
            EnterpriseGroupMo enterpriseGroupMo;
            List<GroupFlowVo> groupFlowVoList = this.localDayChannelInfoEsSumMapper.queryAllGroup(record.getEnterpriseId(), enterpriseFlowQuery.getStartTime(), enterpriseFlowQuery.getEndTime());
            record.setGroupFlowList(groupFlowVoList);
            List licenseIdList = groupFlowVoList.stream().map(license -> "" + license.getLicensesId()).collect(Collectors.toList());
            String ids = String.join((CharSequence)",", licenseIdList);
            MmsBaseRes licensesDetail = this.mmsService.getLicensesDetail(ids);
            Map licensesResMap = (Map)licensesDetail.getData();
            licensesResMap.values().forEach(goldLicensesRes -> {
                record.setUsedBandwidth(record.getUsedBandwidth() + goldLicensesRes.getRealtime_rate());
                record.setUsedChannel(record.getUsedChannel() + goldLicensesRes.getUsedChns());
            });
            record.setMaxBandwidthStr(Util.ByteSizeUnit.M.format((long)record.getMaxBandwidth(), Util.ByteSizeUnit.B, 2, false));
            record.setUsedBandwidthStr(Util.ByteSizeUnit.M.format((long)record.getUsedBandwidth(), Util.ByteSizeUnit.B, 2, false));
            record.setMaxCapacityStr(Util.ByteSizeUnit.G.format(record.getMaxCapacity(), Util.ByteSizeUnit.B, 2, false));
            record.setUsedCapacityStr(Util.ByteSizeUnit.G.format(record.getUsedCapacity(), Util.ByteSizeUnit.B, 2, false));
            if (enterpriseFlowQuery.isFetchGroupFlow()) {
                List groupIdList = groupFlowVoList.stream().map(GroupFlowVo::getId).collect(Collectors.toList());
                LambdaQueryWrapper groupOrgQueryWrapper = new LambdaQueryWrapper();
                groupOrgQueryWrapper.in(GroupOrgGprsLicenses::getGroupId, groupIdList);
                List orgGprsLicensesList = this.groupOrgGprsLicenceMapper.selectList((Wrapper)groupOrgQueryWrapper);
                Map<Long, List<OrgInfo>> listMap = this.orgName(orgGprsLicensesList);
                for (GroupFlowVo groupFlowVo : groupFlowVoList) {
                    groupFlowVo.setMaxBandwidthStr(Util.ByteSizeUnit.M.format((long)groupFlowVo.getMaxBandwidth(), Util.ByteSizeUnit.B, 2, false));
                    groupFlowVo.setMaxCapacityStr(Util.ByteSizeUnit.G.format(groupFlowVo.getMaxCapacity(), Util.ByteSizeUnit.B, 2, false));
                    groupFlowVo.setUsedCapacityStr(Util.ByteSizeUnit.G.format(groupFlowVo.getUsedCapacity(), Util.ByteSizeUnit.B, 2, false));
                    GoldLicensesRes goldLicensesRes2 = (GoldLicensesRes)licensesResMap.get(groupFlowVo.getLicensesId());
                    groupFlowVo.setUsedBandwidth(goldLicensesRes2.getRealtime_rate());
                    groupFlowVo.setUsedBandwidthStr(Util.ByteSizeUnit.M.format((long)groupFlowVo.getUsedBandwidth(), Util.ByteSizeUnit.B, 2, false));
                    groupFlowVo.setUsedChannel(goldLicensesRes2.getUsedChns());
                    groupFlowVo.setTypeStr(GroupType.name(groupFlowVo.getType()));
                    List<OrgInfo> orgInfoList = listMap.get(groupFlowVo.getId());
                    groupFlowVo.setOrgInfoList(orgInfoList);
                }
            }
            if ((enterpriseGroupMo = enterpriseGroupMoMap.get(record.getEnterpriseId())) == null) continue;
            record.setEnterpriseName(enterpriseGroupMo.getName());
            record.setExpiredDateStr(enterpriseGroupMo.getValidateDate() == null ? null : Util.formatTime((Date)enterpriseGroupMo.getValidateDate(), (String[])new String[0]));
        }
        return PageModel.from((long)pageNumber, (int)pageSize, (long)groupFlowVoIPage.getTotal(), (List)groupFlowVoIPage.getRecords());
    }

    private Map<Long, List<OrgInfo>> orgName(List<GroupOrgGprsLicenses> groupOrgVos) {
        HashMap<Long, List<OrgInfo>> map = new HashMap<Long, List<OrgInfo>>();
        List orgIdList = groupOrgVos.stream().filter(groupOrgVo -> OrgType.M.getType() == groupOrgVo.getOrgType().intValue()).map(groupOrgVo -> groupOrgVo.getOrgId()).collect(Collectors.toList());
        BaseResult baseResult = this.departmentApi.getDepartmentByIds(orgIdList);
        groupOrgVos.stream().filter(groupOrgVo -> OrgType.O.getType() == groupOrgVo.getOrgType().intValue()).forEach(groupOrgVo -> {
            BaseResult result1 = this.organizeApi.getOrganizeById(groupOrgVo.getOrgId());
            if (!result1.getIsError().booleanValue()) {
                OrgInfo orgInfo = new OrgInfo();
                orgInfo.setOrgId(groupOrgVo.getOrgId());
                orgInfo.setName(((OrganizePojo)result1.getData()).getName());
                map.computeIfAbsent(groupOrgVo.getGroupId(), k -> new ArrayList()).add(orgInfo);
            }
        });
        if (!baseResult.getIsError().booleanValue()) {
            groupOrgVos.stream().filter(groupOrgVo -> OrgType.M.getType() == groupOrgVo.getOrgType().intValue()).forEach(groupOrgVo -> {
                for (DepartmentPojo departmentPojo : (List)baseResult.getData()) {
                    if (groupOrgVo.getOrgId().compareTo(departmentPojo.getId()) != 0) continue;
                    OrgInfo orgInfo = new OrgInfo();
                    orgInfo.setOrgId(groupOrgVo.getOrgId());
                    orgInfo.setName(departmentPojo.getName());
                    map.computeIfAbsent(groupOrgVo.getGroupId(), k -> new ArrayList()).add(orgInfo);
                    break;
                }
            });
        }
        return map;
    }

    public static enum GroupType {
        XD(1, "\u5de1\u5e97"),
        DSQ(2, "\u7535\u89c6\u5899"),
        AI(3, "AI"),
        CLOUD(4, "\u4e91\u5b58\u50a8"),
        KITCHEN_APP(5, "\u653e\u5fc3\u53a8\u623fAPP"),
        KITCHEN_H5(6, "\u653e\u5fc3\u53a8\u623fH5");

        private int type;
        private String name;

        private GroupType(int type, String name) {
            this.type = type;
            this.name = name;
        }

        static String name(int type) {
            return GroupType.XD.type == type ? GroupType.XD.name : (GroupType.DSQ.type == type ? GroupType.DSQ.name : (GroupType.AI.type == type ? GroupType.AI.name : (GroupType.CLOUD.type == type ? GroupType.CLOUD.name : (GroupType.KITCHEN_APP.type == type ? GroupType.KITCHEN_APP.name : (GroupType.KITCHEN_H5.type == type ? GroupType.KITCHEN_H5.name : "")))));
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }

    private static enum OrgType {
        M(0, "M"),
        O(1, "O");

        private int type;
        private String name;

        private OrgType(int type, String name) {
            this.type = type;
            this.name = name;
        }

        static String name(int type) {
            return OrgType.M.type == type ? OrgType.M.name : (OrgType.O.type == type ? OrgType.O.name : "");
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

