/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.manage.diskerror;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.device.modules.manage.diskerror.DiskStatInfo;
import com.ovopark.device.modules.manage.diskerror.DiskStatQuery;
import com.ovopark.device.modules.manage.diskerror.DiskStatService;
import com.ovopark.device.modules.manage.mysql.DiskSmartStatInfo;
import com.ovopark.device.modules.manage.mysql.DiskSmartStatInfoMapper;
import com.ovopark.device.modules.platform.config.OpenApiConfig;
import com.ovopark.device.modules.platform.openapi.OpenApiSender;
import com.ovopark.device.platform.api.RPCFacade;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.PageModel;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DiskStatServiceImpl
implements DiskStatService {
    @Autowired
    private DiskSmartStatInfoMapper diskSmartStatInfoMapper;
    @Autowired
    private OpenApiSender openApiSender;
    @Autowired
    private OpenApiConfig openApiConfig;
    @Autowired
    private RPCFacade rpcFacade;

    @Override
    public void insert(Map<String, Object> diskSmartMap) {
        DiskSmartStatInfo diskSmartStatInfo = new DiskSmartStatInfo();
        diskSmartStatInfo.setUuid(Util.convert2String((Object)diskSmartMap.get("uid")));
        diskSmartStatInfo.setDeptId(Util.convert2Int((String)Util.convert2String((Object)diskSmartMap.get("shopId")), null));
        diskSmartStatInfo.setDeptName(Util.convert2String((Object)diskSmartMap.get("ShopName")));
        diskSmartStatInfo.setMac(Util.convert2String((Object)diskSmartMap.get("Mac")));
        diskSmartStatInfo.setDeviceType(Util.convert2String((Object)diskSmartMap.get("DeviceType")));
        diskSmartStatInfo.setDiskSeq(Util.convert2String((Object)diskSmartMap.get("SerialNumber")));
        diskSmartStatInfo.setDiskType(Util.convert2String((Object)diskSmartMap.get("Model")));
        diskSmartStatInfo.setDiskCapacity(Util.convert2String((Object)diskSmartMap.get("Capacity")));
        diskSmartStatInfo.setErrorCount(Util.convert2Int((String)Util.convert2String((Object)diskSmartMap.get("Score")), (Integer)0));
        diskSmartStatInfo.setMountFlag(Util.convert2String((Object)diskSmartMap.get("IsOnline")));
        diskSmartStatInfo.setRepartitionSectors(Util.convert2String((Object)diskSmartMap.get("Reallocated_Sector_Ct")));
        diskSmartStatInfo.setOriginalErrorRate(Util.convert2String((Object)diskSmartMap.get("Raw_Read_Error_Rate")));
        diskSmartStatInfo.setStartupTime(Util.convert2String((Object)diskSmartMap.get("Spin_Up_Time")));
        diskSmartStatInfo.setPowerOnTime(Util.convert2String((Object)diskSmartMap.get("Power_On_Hours")));
        diskSmartStatInfo.setTemperature(Util.convert2String((Object)diskSmartMap.get("Temperature_Celsius")));
        diskSmartStatInfo.setCommandTimeout(Util.convert2String((Object)diskSmartMap.get("Command_Timeout")));
        diskSmartStatInfo.setRepartitionCount(Util.convert2String((Object)diskSmartMap.get("Reallocated_Event_Count")));
        diskSmartStatInfo.setMountCount(Util.convert2String((Object)diskSmartMap.get("Current_Pending_Sector")));
        diskSmartStatInfo.setTime(Util.dateTime((long)(Util.convert2Int((String)Util.convert2String((Object)diskSmartMap.get("timeStamp"), null), (Integer)0) * 1000)));
        this.diskSmartStatInfoMapper.insert(diskSmartStatInfo);
        Integer groupId = null;
        if (diskSmartStatInfo.getErrorCount() > 0) {
            DiskStatInfo diskStatInfo = new DiskStatInfo();
            BeanUtils.copyProperties((Object)diskSmartStatInfo, (Object)diskStatInfo);
            this.openApiSender.send2OpenApi((Object)diskStatInfo, 0, groupId, null, this.openApiConfig.getDiskSmartErrorModuleKey());
        }
    }

    @Override
    public PageModel<DiskStatInfo> query(DiskStatQuery diskStatQuery) {
        LocalDate start = LocalDate.now().minusDays(1L);
        LocalDateTime end = start.atTime(LocalTime.of(23, 59, 59));
        ArrayList<Integer> deptIdList = new ArrayList<Integer>();
        if (diskStatQuery.getDeptId() != null) {
            deptIdList.add(diskStatQuery.getDeptId());
        } else if (diskStatQuery.getEnterpriseId() != null) {
            List depIdsByEnterpriseId = this.rpcFacade.getDepIdsByEnterpriseId(diskStatQuery.getEnterpriseId());
            deptIdList.addAll(depIdsByEnterpriseId);
        }
        if (Util.isEmpty(deptIdList)) {
            return PageModel.empty((long)diskStatQuery.getPageNumber(), (int)diskStatQuery.getPageSize(), (long)0L);
        }
        Page page = new Page();
        page.setCurrent(diskStatQuery.getPageNumber());
        page.setSize((long)diskStatQuery.getPageSize());
        Page diskSmartStatInfoPage = (Page)this.diskSmartStatInfoMapper.selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper(DiskSmartStatInfo.class).ge(DiskSmartStatInfo::getTime, (Object)start)).le(DiskSmartStatInfo::getTime, (Object)end)).in(DiskSmartStatInfo::getDeptId, deptIdList)).orderByAsc(DiskSmartStatInfo::getUuid));
        List<DiskStatInfo> list = diskSmartStatInfoPage.getRecords().stream().map(diskSmartStatInfo -> {
            DiskStatInfo diskStatInfo = new DiskStatInfo();
            BeanUtils.copyProperties((Object)diskSmartStatInfo, (Object)diskStatInfo);
            return diskStatInfo;
        }).toList();
        return PageModel.from((long)diskStatQuery.getPageNumber(), (int)diskStatQuery.getPageSize(), (long)diskSmartStatInfoPage.getTotal(), list);
    }
}

