/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.manage;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.common.util.CommonException;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.modules.manage.model.kafka.KKDeviceInfoKo;
import com.ovopark.device.modules.manage.model.kafka.KkBaseKo;
import com.ovopark.device.modules.platform.ConditionOnKafka;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.platform.api.model.ChildDeviceAddMo;
import com.ovopark.device.thirdparty.ovoIot.util.IotJsonUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.stereotype.Component;

@ConditionOnKafka
@Component
public class KKKafkaInStream {
    private static final Logger log = LoggerFactory.getLogger(KKKafkaInStream.class);
    @Autowired
    private DeviceStatusService deviceStatusService;

    @KafkaListener(concurrency="${messagehub.control.sdk.kafka.concurrency:10}", properties={"partition.assignment.strategy:org.apache.kafka.clients.consumer.CooperativeStickyAssignor"}, topicPattern="TZ-MCB-GROUP-001", groupId="${device.iotKK.kafka.group:iotKK}", containerFactory="dmsKafkaContainerFactory", id="iot-kk")
    public void message(ConsumerRecord<String, Object> record) {
        String topic = record.topic();
        int partition = record.partition();
        long offset = record.offset();
        String value = (String)record.value();
        log.info(Thread.currentThread().hashCode() + ",topic: " + topic + ", partition: " + partition + ", offset: " + offset + ",iotKK value: " + value);
        String msgType = "";
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            JsonNode rootNode = null;
            try {
                rootNode = JsonUtils.objectMapper.readTree(value);
            }
            catch (Exception e) {
                throw new CommonException(ExceptionEnum.JSON_ERR);
            }
            msgType = rootNode.path("msgType").asText();
        }
        if (StringUtils.isNotEmpty((CharSequence)msgType) && "device_info".equals(msgType)) {
            try {
                KKDeviceInfoKo msg;
                KkBaseKo deviceInfo = (KkBaseKo)IotJsonUtils.objectMapper.readValue(value, (TypeReference)new TypeReference<KkBaseKo<KKDeviceInfoKo>>(this){});
                if (deviceInfo != null && (msg = (KKDeviceInfoKo)deviceInfo.getMsg()) != null) {
                    ChildDeviceAddMo childDeviceAddMo = new ChildDeviceAddMo();
                    String mainMac = msg.getClientId().replace("-TPIoT", "");
                    childDeviceAddMo.setMainMac(mainMac);
                    childDeviceAddMo.setChildMac(msg.getBreakId());
                    childDeviceAddMo.setDeviceType("tzwg-child");
                    childDeviceAddMo.setDtype(Integer.valueOf(193));
                    childDeviceAddMo.setChannelId(Integer.valueOf(0));
                    this.deviceStatusService.addChild(childDeviceAddMo);
                }
            }
            catch (Exception e) {
                log.error("device_info json err:{}", (Object)e.getMessage());
                throw new CommonException(ExceptionEnum.JSON_ERR);
            }
        }
    }
}

