/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.common.response.ExceptionEnum;
import com.ovopark.device.modules.platform.DeviceNewService;
import com.ovopark.device.modules.platform.DevicePresetService;
import com.ovopark.device.modules.platform.DeviceStatusService;
import com.ovopark.device.modules.platform.RedisLock;
import com.ovopark.device.modules.platform.mysql.DevicePreset;
import com.ovopark.device.modules.platform.mysql.DevicePresetMapper;
import com.ovopark.device.modules.platform.mysql.DeviceStatus;
import com.ovopark.device.modules.platform.mysql.Devices;
import com.ovopark.device.thirdparty.ovoIot.model.common.CommonException;
import jakarta.annotation.Resource;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DevicePresetServiceImpl
implements DevicePresetService {
    private static final Logger log = LoggerFactory.getLogger(DevicePresetServiceImpl.class);
    @Autowired
    private DevicePresetMapper devicePresetMapper;
    @Autowired
    private DeviceNewService deviceNewService;
    @Autowired
    private DeviceStatusService deviceStatusService;
    @Resource
    private RedisLock redisLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer createNewPresetNum(Integer userId, Integer deviceId) {
        String lockKey = "d:createNewPresetNum:" + deviceId;
        String requestId = UUID.randomUUID().toString();
        try {
            boolean locked = this.redisLock.tryLock(lockKey, requestId, 30L, TimeUnit.SECONDS);
            if (!locked) {
                throw new com.ovopark.device.common.util.CommonException(ExceptionEnum.PLEASE_TRY_AGAIN_LATER);
            }
            Devices devices = this.deviceNewService.getDeviceById(deviceId);
            if (devices == null || devices.getIsDelete() == 1) {
                throw new CommonException(com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum.DEVICE_NOT_EXIST);
            }
            Integer deviceinfoId = devices.getDeviceinfoId();
            if (deviceinfoId == null) {
                throw new CommonException(com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum.DEVICE_NOT_SUPPORTED);
            }
            DeviceStatus deviceStatus = this.deviceStatusService.getById(deviceinfoId);
            if (deviceStatus == null || deviceStatus.getIsDelete() == 1) {
                throw new CommonException(com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum.DEVICE_NOT_EXIST);
            }
            Integer dType = deviceStatus.getDType();
            if (dType == null) {
                throw new CommonException(com.ovopark.device.thirdparty.ovoIot.model.common.ExceptionEnum.DEVICE_NOT_SUPPORTED);
            }
            Integer presetNum = null;
            if (dType == 62) {
                presetNum = -1;
            } else {
                List devicePresets = this.devicePresetMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DevicePreset::getDeviceId, (Object)deviceId)).orderByDesc(DevicePreset::getPresetNum)).last(" limit 1"));
                DevicePreset preset = null;
                DevicePreset p = new DevicePreset();
                p.setDeviceId(deviceId);
                p.setCreateBy(userId);
                p.setCreateAt(LocalDateTime.now());
                if (CollectionUtils.isNotEmpty((Collection)devicePresets)) {
                    preset = (DevicePreset)devicePresets.getFirst();
                    p.setPresetNum(preset.getPresetNum() + 1);
                } else {
                    p.setPresetNum(0);
                }
                this.devicePresetMapper.insert(p);
                presetNum = p.getPresetNum();
            }
            Integer n = presetNum;
            return n;
        }
        finally {
            this.redisLock.releaseLock(lockKey, requestId);
        }
    }
}

