/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.cloud.api.DeviceApi;
import com.ovopark.device.cloud.api.DeviceStatusApi;
import com.ovopark.device.cloud.common.model.mo.DevicesOnlineMo;
import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.platform.api.OnlineFacade;
import com.ovopark.device.platform.api.model.OnOffVo;
import com.ovopark.device.sdk.api.TempEzvizApi;
import com.ovopark.device.sdk.common.model.mo.GetEzvizDeviceOnlineMapFeignMo;
import com.ovopark.kernel.shared.Util;
import com.ovopark.module.shared.BaseResult;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="com.ovopark.device.modules.platform.OnlineFacadeRPC")
public class OnlineFacadeRPC
implements OnlineFacade {
    private static final Logger log = LoggerFactory.getLogger(OnlineFacadeRPC.class);
    public static final String BEAN_NAME = "com.ovopark.device.modules.platform.OnlineFacadeRPC";
    @Resource
    private DeviceStatusApi deviceStatusApi;
    @Resource
    private DeviceApi deviceApi;
    @Autowired
    private TempEzvizApi tempEzvizApi;

    public Map<Integer, Integer> onOffRT(List<Integer> deviceStatusIdList) {
        com.ovopark.device.common.response.BaseResult dmsOnlineMap = this.deviceStatusApi.getDmsOnlineMap(deviceStatusIdList);
        if (dmsOnlineMap != null && !dmsOnlineMap.getIsError().booleanValue()) {
            return (Map)dmsOnlineMap.getData();
        }
        return null;
    }

    public Map<Integer, Integer> onOffNRT(List<Integer> deviceStatusIdList) {
        return this.onOffRT(deviceStatusIdList);
    }

    public Map<Integer, OnOffVo> onOffTimeRT(List<Integer> deviceStatusIdList) {
        com.ovopark.device.common.response.BaseResult dmsOnOffMap = this.deviceStatusApi.getDmsOnOffMap(deviceStatusIdList);
        if (dmsOnOffMap != null && !dmsOnOffMap.getIsError().booleanValue() && Util.isNotEmpty((Map)((Map)dmsOnOffMap.getData()))) {
            HashMap<Integer, OnOffVo> onOffVoMap = new HashMap<Integer, OnOffVo>();
            ((Map)dmsOnOffMap.getData()).forEach((k, v) -> {
                OnOffVo onOffVo = new OnOffVo();
                onOffVo.setId(v.getId());
                onOffVo.setOnline(v.getOnline());
                onOffVo.setOfflineTimeStamp(v.getOfflineTimeStamp());
                onOffVo.setOnlineTimeStamp(v.getOnlineTimeStamp().longValue());
                onOffVoMap.put((Integer)k, onOffVo);
            });
            return onOffVoMap;
        }
        return null;
    }

    public Map<Integer, OnOffVo> onOffTimeNRT(List<Integer> deviceStatusIdList) {
        return this.onOffTimeRT(deviceStatusIdList);
    }

    public Map<Integer, Integer> getVideoOnlineMap(List<Integer> deviceIdList) {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        try {
            com.ovopark.device.common.response.BaseResult deviceOnlineStatus = this.deviceApi.getDeviceOnlineStatus(deviceIdList);
            log.info("onOffService.getDeviceOnlineStatus res {}", (Object)JsonUtils.beanToJsonStringForLog((Object)deviceOnlineStatus));
            List data = (List)deviceOnlineStatus.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (DevicesOnlineMo item : data) {
                    Integer devicesId = item.getDevicesId();
                    Integer onlineFlag = item.getOnlineFlag();
                    result.put(devicesId, onlineFlag);
                }
            }
        }
        catch (Exception e) {
            log.error("onOffService.getDeviceOnlineStatus err param:{} ,err {}", (Object)JsonUtils.beanToJsonStringForLog(deviceIdList), (Object)e.getMessage());
        }
        return result;
    }

    public Map<String, Integer> onOffRT_YS(List<String> deviceSerialList) {
        GetEzvizDeviceOnlineMapFeignMo getEzvizDeviceOnlineMapFeignMo = new GetEzvizDeviceOnlineMapFeignMo();
        getEzvizDeviceOnlineMapFeignMo.setDeviceSerialList(deviceSerialList);
        getEzvizDeviceOnlineMapFeignMo.setToken(null);
        BaseResult baseResult = this.tempEzvizApi.getEzvizDeviceOnlineMap(getEzvizDeviceOnlineMapFeignMo);
        if (baseResult != null && !baseResult.getIsError().booleanValue()) {
            return (Map)baseResult.getData();
        }
        return null;
    }
}

