/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.ovopark.device.common.util.JsonUtils;
import com.ovopark.device.common.util.LogUtil;
import com.ovopark.device.platform.api.DepartmentFacade;
import com.ovopark.kernel.shared.Util;
import com.ovopark.organize.common.base.BaseResult;
import com.ovopark.organize.common.model.mo.DepIdsAndUserMo;
import com.ovopark.organize.common.model.mo.DepartmentOrgMo;
import com.ovopark.organize.common.model.pojo.DepartmentPojo;
import com.ovopark.organize.common.model.pojo.SimplePojo;
import com.ovopark.organize.sdk.api.DepartmentApi;
import com.ovopark.organize.sdk.api.UserDepPrivilegeApi;
import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="departmentService")
public class DepartmentFacadeImpl
implements DepartmentFacade {
    private static final Logger log = LoggerFactory.getLogger(DepartmentFacadeImpl.class);
    @Resource
    private UserDepPrivilegeApi userDepPrivilegeApi;
    @Resource
    private DepartmentApi departmentApi;

    public Map<Integer, DepartmentOrgMo> getUserDepNameMapNew(DepIdsAndUserMo mo) {
        HashMap<Integer, DepartmentOrgMo> result = new HashMap<Integer, DepartmentOrgMo>();
        try {
            BaseResult userPrivilegeDepByOrganizeIds = this.userDepPrivilegeApi.getUserPrivilegeDepByOrganizeIds(mo);
            List data = (List)userPrivilegeDepByOrganizeIds.getData();
            if (Util.isNotEmpty((Collection)data)) {
                for (DepartmentOrgMo item : data) {
                    result.put(item.getDepId(), item);
                }
            } else {
                log.error("userDepPrivilegeApi.getUserPrivilegeDepByOrganizeIds param:{} res:{}", (Object)JsonUtils.beanToJsonStringForLog((Object)mo), (Object)JsonUtils.beanToJsonStringForLog((Object)userPrivilegeDepByOrganizeIds));
            }
        }
        catch (Exception e) {
            log.error("userDepPrivilegeApi.getUserPrivilegeDepByOrganizeIds err {}", (Object)LogUtil.getStackTraceInfo((Exception)e));
        }
        return result;
    }

    public List<SimplePojo> getDepPathById(Integer groupId, List<Integer> deptIds) {
        try {
            BaseResult baseResult = this.departmentApi.getDepPathById(groupId, deptIds);
            if (baseResult.getIsError().booleanValue()) {
                log.error("departmentApi.getDepPathById{}", (Object)baseResult);
            }
            return (List)baseResult.getData();
        }
        catch (Exception e) {
            log.error("departmentApi.getDepPathById\uff0c\u5f02\u5e38\u5185\u5bb9:{}", (Object)e.toString());
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String getDepName(@NotNull Integer depId) {
        try {
            BaseResult baseResult = this.departmentApi.getDepartmentById(depId);
            log.info("departmentApi.getDepName param :{} res:{}", (Object)depId.toString(), (Object)JsonUtils.beanToJsonStringForLog((Object)baseResult));
            if (!baseResult.getIsError().booleanValue()) {
                DepartmentPojo data = (DepartmentPojo)baseResult.getData();
                if (data != null) {
                    return data.getName();
                }
                return "";
            }
            log.error("departmentApi.getDepName{}", (Object)JsonUtils.beanToJsonStringForLog((Object)baseResult));
        }
        catch (Exception e) {
            log.error("departmentApi.getDepName\uff0c\u5f02\u5e38\u5185\u5bb9:{}", (Object)e.toString());
        }
        return "";
    }

    public Map<Integer, String> getUserDepNameMap(Integer userId, Integer enterpriseId, String organizeId) {
        HashMap<Integer, String> nameMap = new HashMap<Integer, String>();
        DepIdsAndUserMo mo = new DepIdsAndUserMo();
        mo.setUserId(userId);
        mo.setUserGroupId(enterpriseId);
        if (Util.isNotEmpty((CharSequence)organizeId)) {
            String[] split = organizeId.split(",");
            mo.setOrganizeIdList(Arrays.asList(split));
        }
        mo.setIsDel(Integer.valueOf(0));
        Map<Integer, DepartmentOrgMo> userDepNameMapNew = this.getUserDepNameMapNew(mo);
        for (Integer depId : userDepNameMapNew.keySet()) {
            DepartmentOrgMo departmentOrgMo = userDepNameMapNew.get(depId);
            if (departmentOrgMo == null) continue;
            nameMap.put(depId, departmentOrgMo.getName());
        }
        return nameMap;
    }
}

