/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.reportpfconfig.devicereport;

import com.ovopark.device.signalling.model.response.BaseRes;
import com.ovopark.device.signalling.model.response.SetPflowReidCfgRes;
import com.ovopark.device.signalling.socket.SocketUtil;
import com.ovopark.device.signalling.util.PassengerFlowUtil;
import com.ovopark.device.thirdparty.ovoIot.model.Dms2New1Res;
import com.ovopark.device.thirdparty.ovoIot.model.dms.MultiReidInitCfgReq;
import com.ovopark.device.thirdparty.ovoIot.service.NvrService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DeviceFlowReidConfigReportAcl {
    private static final Logger log = LoggerFactory.getLogger(DeviceFlowReidConfigReportAcl.class);
    @Resource
    private NvrService nvrService;
    private static DeviceFlowReidConfigReportAcl util;

    @PostConstruct
    public void init() {
        util = this;
        DeviceFlowReidConfigReportAcl.util.nvrService = this.nvrService;
    }

    public static PlatformReidConfigOutParam getDeviceFlowReidConfigReport(PlatformReidConfigInParam platformReidConfigInParam) {
        try {
            Dms2New1Res multiReidInitCfg;
            MultiReidInitCfgReq multiReidInitCfgReq;
            SetPflowReidCfgRes data = null;
            if (platformReidConfigInParam.getDeviceType().contains("PC8")) {
                BaseRes pFlowReidCfg = PassengerFlowUtil.getPflowReidCfg((String)platformReidConfigInParam.getMac(), (String)platformReidConfigInParam.getUpgradeServer(), (Integer)platformReidConfigInParam.getUpgradePort(), (String)SocketUtil.authentication);
                data = (SetPflowReidCfgRes)pFlowReidCfg.getData();
            } else if (platformReidConfigInParam.getDeviceType().contains("Dolphin1") && (multiReidInitCfgReq = (MultiReidInitCfgReq)(multiReidInitCfg = DeviceFlowReidConfigReportAcl.util.nvrService.getMultiReidInitCfg(platformReidConfigInParam.getMac())).getData()) != null) {
                data = new SetPflowReidCfgRes();
                data.setEnableStorePasserby(multiReidInitCfgReq.enableStorePasserby != null ? multiReidInitCfgReq.enableStorePasserby : null);
                data.setDayReidEndHour(multiReidInitCfgReq.dayReidEndHour != null ? multiReidInitCfgReq.dayReidEndHour : null);
                data.setDayReidEndMinute(multiReidInitCfgReq.dayReidEndMinute != null ? multiReidInitCfgReq.dayReidEndMinute : null);
                data.setEmployeeBeginHour(multiReidInitCfgReq.employeeBeginHour != null ? multiReidInitCfgReq.employeeBeginHour : null);
                data.setEmployeeBeginMinute(multiReidInitCfgReq.employeeBeginMinute != null ? multiReidInitCfgReq.employeeBeginMinute : null);
                data.setEmployeeBeginSecond(multiReidInitCfgReq.employeeBeginSecond != null ? multiReidInitCfgReq.employeeBeginSecond : null);
                data.setEmployeeEndHour(multiReidInitCfgReq.employeeEndHour != null ? multiReidInitCfgReq.employeeEndHour : null);
                data.setEmployeeEndMinute(multiReidInitCfgReq.employeeEndMinute != null ? multiReidInitCfgReq.employeeEndMinute : null);
                data.setEmployeeEndSecond(multiReidInitCfgReq.employeeEndSecond != null ? multiReidInitCfgReq.employeeEndSecond : null);
                data.setEmployeeCompareLevel(multiReidInitCfgReq.employeeCompareLevel != null ? multiReidInitCfgReq.employeeCompareLevel : null);
                data.setEmployeeTimeThreshold(multiReidInitCfgReq.employeeTimeThreshold != null ? Integer.valueOf("" + multiReidInitCfgReq.employeeTimeThreshold) : null);
                data.setEmployeeTrackThreshold(multiReidInitCfgReq.employeeTrackThreshold != null ? multiReidInitCfgReq.employeeTrackThreshold : null);
                data.setEmployeeTimeMarkEnable(Boolean.valueOf(multiReidInitCfgReq.employeeTimeMarkEnable != null ? multiReidInitCfgReq.employeeTimeMarkEnable : false));
            }
            PlatformReidConfigOutParam platformReidConfigOutParam = DeviceFlowReidConfigReportAcl.modelConvert(data);
            return platformReidConfigOutParam;
        }
        catch (Exception e) {
            log.error("DeviceFlowReidConfigReportAcl \u83b7\u53d6pc8\u8bbe\u5907\u914d\u7f6e\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private static PlatformReidConfigOutParam modelConvert(SetPflowReidCfgRes data) {
        if (data == null) {
            return null;
        }
        return new PlatformReidConfigOutParam(data.getDayReidEndHour(), data.getDayReidEndMinute(), data.getEnableStorePasserby(), data.getEmployeeBeginHour(), data.getEmployeeBeginMinute(), data.getEmployeeBeginSecond(), data.getEmployeeEndHour(), data.getEmployeeEndMinute(), data.getEmployeeEndSecond(), data.getEmployeeTimeMarkEnable(), data.getEmployeeCompareLevel(), data.getEmployeeTimeThreshold(), data.getEmployeeTrackThreshold());
    }

    public static class PlatformReidConfigInParam {
        private String upgradeServer;
        private Integer upgradePort;
        private String mac;
        private String deviceType;

        public PlatformReidConfigInParam(String upgradeServer, Integer upgradePort, String mac, String deviceType) {
            this.upgradeServer = upgradeServer;
            this.upgradePort = upgradePort;
            this.mac = mac;
            this.deviceType = deviceType;
        }

        public String getUpgradeServer() {
            return this.upgradeServer;
        }

        public Integer getUpgradePort() {
            return this.upgradePort;
        }

        public String getMac() {
            return this.mac;
        }

        public String getDeviceType() {
            return this.deviceType;
        }

        public void setUpgradeServer(String upgradeServer) {
            this.upgradeServer = upgradeServer;
        }

        public void setUpgradePort(Integer upgradePort) {
            this.upgradePort = upgradePort;
        }

        public void setMac(String mac) {
            this.mac = mac;
        }

        public void setDeviceType(String deviceType) {
            this.deviceType = deviceType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlatformReidConfigInParam)) {
                return false;
            }
            PlatformReidConfigInParam other = (PlatformReidConfigInParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$upgradePort = this.getUpgradePort();
            Integer other$upgradePort = other.getUpgradePort();
            if (this$upgradePort == null ? other$upgradePort != null : !((Object)this$upgradePort).equals(other$upgradePort)) {
                return false;
            }
            String this$upgradeServer = this.getUpgradeServer();
            String other$upgradeServer = other.getUpgradeServer();
            if (this$upgradeServer == null ? other$upgradeServer != null : !this$upgradeServer.equals(other$upgradeServer)) {
                return false;
            }
            String this$mac = this.getMac();
            String other$mac = other.getMac();
            if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
                return false;
            }
            String this$deviceType = this.getDeviceType();
            String other$deviceType = other.getDeviceType();
            return !(this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlatformReidConfigInParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $upgradePort = this.getUpgradePort();
            result = result * 59 + ($upgradePort == null ? 43 : ((Object)$upgradePort).hashCode());
            String $upgradeServer = this.getUpgradeServer();
            result = result * 59 + ($upgradeServer == null ? 43 : $upgradeServer.hashCode());
            String $mac = this.getMac();
            result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
            String $deviceType = this.getDeviceType();
            result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
            return result;
        }

        public String toString() {
            return "DeviceFlowReidConfigReportAcl.PlatformReidConfigInParam(upgradeServer=" + this.getUpgradeServer() + ", upgradePort=" + this.getUpgradePort() + ", mac=" + this.getMac() + ", deviceType=" + this.getDeviceType() + ")";
        }

        public PlatformReidConfigInParam() {
        }
    }

    public static class PlatformReidConfigOutParam {
        private Integer dayReidEndHour;
        private Integer dayReidEndMinute;
        private Boolean enableStorePasserby;
        private Integer employeeBeginHour;
        private Integer employeeBeginMinute;
        private Integer employeeBeginSecond;
        private Integer employeeEndHour;
        private Integer employeeEndMinute;
        private Integer employeeEndSecond;
        private Boolean employeeTimeMarkEnable;
        private Integer employeeCompareLevel;
        private Integer employeeTimeThreshold;
        private Integer employeeTrackThreshold;

        public PlatformReidConfigOutParam(Integer dayReidEndHour, Integer dayReidEndMinute, Boolean enableStorePasserby, Integer employeeBeginHour, Integer employeeBeginMinute, Integer employeeBeginSecond, Integer employeeEndHour, Integer employeeEndMinute, Integer employeeEndSecond, Boolean employeeTimeMarkEnable, Integer employeeCompareLevel, Integer employeeTimeThreshold, Integer employeeTrackThreshold) {
            this.dayReidEndHour = dayReidEndHour;
            this.dayReidEndMinute = dayReidEndMinute;
            this.enableStorePasserby = enableStorePasserby;
            this.employeeBeginHour = employeeBeginHour;
            this.employeeBeginMinute = employeeBeginMinute;
            this.employeeBeginSecond = employeeBeginSecond;
            this.employeeEndHour = employeeEndHour;
            this.employeeEndMinute = employeeEndMinute;
            this.employeeEndSecond = employeeEndSecond;
            this.employeeTimeMarkEnable = employeeTimeMarkEnable;
            this.employeeCompareLevel = employeeCompareLevel;
            this.employeeTimeThreshold = employeeTimeThreshold;
            this.employeeTrackThreshold = employeeTrackThreshold;
        }

        public Integer getDayReidEndHour() {
            return this.dayReidEndHour;
        }

        public Integer getDayReidEndMinute() {
            return this.dayReidEndMinute;
        }

        public Boolean getEnableStorePasserby() {
            return this.enableStorePasserby;
        }

        public Integer getEmployeeBeginHour() {
            return this.employeeBeginHour;
        }

        public Integer getEmployeeBeginMinute() {
            return this.employeeBeginMinute;
        }

        public Integer getEmployeeBeginSecond() {
            return this.employeeBeginSecond;
        }

        public Integer getEmployeeEndHour() {
            return this.employeeEndHour;
        }

        public Integer getEmployeeEndMinute() {
            return this.employeeEndMinute;
        }

        public Integer getEmployeeEndSecond() {
            return this.employeeEndSecond;
        }

        public Boolean getEmployeeTimeMarkEnable() {
            return this.employeeTimeMarkEnable;
        }

        public Integer getEmployeeCompareLevel() {
            return this.employeeCompareLevel;
        }

        public Integer getEmployeeTimeThreshold() {
            return this.employeeTimeThreshold;
        }

        public Integer getEmployeeTrackThreshold() {
            return this.employeeTrackThreshold;
        }

        public void setDayReidEndHour(Integer dayReidEndHour) {
            this.dayReidEndHour = dayReidEndHour;
        }

        public void setDayReidEndMinute(Integer dayReidEndMinute) {
            this.dayReidEndMinute = dayReidEndMinute;
        }

        public void setEnableStorePasserby(Boolean enableStorePasserby) {
            this.enableStorePasserby = enableStorePasserby;
        }

        public void setEmployeeBeginHour(Integer employeeBeginHour) {
            this.employeeBeginHour = employeeBeginHour;
        }

        public void setEmployeeBeginMinute(Integer employeeBeginMinute) {
            this.employeeBeginMinute = employeeBeginMinute;
        }

        public void setEmployeeBeginSecond(Integer employeeBeginSecond) {
            this.employeeBeginSecond = employeeBeginSecond;
        }

        public void setEmployeeEndHour(Integer employeeEndHour) {
            this.employeeEndHour = employeeEndHour;
        }

        public void setEmployeeEndMinute(Integer employeeEndMinute) {
            this.employeeEndMinute = employeeEndMinute;
        }

        public void setEmployeeEndSecond(Integer employeeEndSecond) {
            this.employeeEndSecond = employeeEndSecond;
        }

        public void setEmployeeTimeMarkEnable(Boolean employeeTimeMarkEnable) {
            this.employeeTimeMarkEnable = employeeTimeMarkEnable;
        }

        public void setEmployeeCompareLevel(Integer employeeCompareLevel) {
            this.employeeCompareLevel = employeeCompareLevel;
        }

        public void setEmployeeTimeThreshold(Integer employeeTimeThreshold) {
            this.employeeTimeThreshold = employeeTimeThreshold;
        }

        public void setEmployeeTrackThreshold(Integer employeeTrackThreshold) {
            this.employeeTrackThreshold = employeeTrackThreshold;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PlatformReidConfigOutParam)) {
                return false;
            }
            PlatformReidConfigOutParam other = (PlatformReidConfigOutParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$dayReidEndHour = this.getDayReidEndHour();
            Integer other$dayReidEndHour = other.getDayReidEndHour();
            if (this$dayReidEndHour == null ? other$dayReidEndHour != null : !((Object)this$dayReidEndHour).equals(other$dayReidEndHour)) {
                return false;
            }
            Integer this$dayReidEndMinute = this.getDayReidEndMinute();
            Integer other$dayReidEndMinute = other.getDayReidEndMinute();
            if (this$dayReidEndMinute == null ? other$dayReidEndMinute != null : !((Object)this$dayReidEndMinute).equals(other$dayReidEndMinute)) {
                return false;
            }
            Boolean this$enableStorePasserby = this.getEnableStorePasserby();
            Boolean other$enableStorePasserby = other.getEnableStorePasserby();
            if (this$enableStorePasserby == null ? other$enableStorePasserby != null : !((Object)this$enableStorePasserby).equals(other$enableStorePasserby)) {
                return false;
            }
            Integer this$employeeBeginHour = this.getEmployeeBeginHour();
            Integer other$employeeBeginHour = other.getEmployeeBeginHour();
            if (this$employeeBeginHour == null ? other$employeeBeginHour != null : !((Object)this$employeeBeginHour).equals(other$employeeBeginHour)) {
                return false;
            }
            Integer this$employeeBeginMinute = this.getEmployeeBeginMinute();
            Integer other$employeeBeginMinute = other.getEmployeeBeginMinute();
            if (this$employeeBeginMinute == null ? other$employeeBeginMinute != null : !((Object)this$employeeBeginMinute).equals(other$employeeBeginMinute)) {
                return false;
            }
            Integer this$employeeBeginSecond = this.getEmployeeBeginSecond();
            Integer other$employeeBeginSecond = other.getEmployeeBeginSecond();
            if (this$employeeBeginSecond == null ? other$employeeBeginSecond != null : !((Object)this$employeeBeginSecond).equals(other$employeeBeginSecond)) {
                return false;
            }
            Integer this$employeeEndHour = this.getEmployeeEndHour();
            Integer other$employeeEndHour = other.getEmployeeEndHour();
            if (this$employeeEndHour == null ? other$employeeEndHour != null : !((Object)this$employeeEndHour).equals(other$employeeEndHour)) {
                return false;
            }
            Integer this$employeeEndMinute = this.getEmployeeEndMinute();
            Integer other$employeeEndMinute = other.getEmployeeEndMinute();
            if (this$employeeEndMinute == null ? other$employeeEndMinute != null : !((Object)this$employeeEndMinute).equals(other$employeeEndMinute)) {
                return false;
            }
            Integer this$employeeEndSecond = this.getEmployeeEndSecond();
            Integer other$employeeEndSecond = other.getEmployeeEndSecond();
            if (this$employeeEndSecond == null ? other$employeeEndSecond != null : !((Object)this$employeeEndSecond).equals(other$employeeEndSecond)) {
                return false;
            }
            Boolean this$employeeTimeMarkEnable = this.getEmployeeTimeMarkEnable();
            Boolean other$employeeTimeMarkEnable = other.getEmployeeTimeMarkEnable();
            if (this$employeeTimeMarkEnable == null ? other$employeeTimeMarkEnable != null : !((Object)this$employeeTimeMarkEnable).equals(other$employeeTimeMarkEnable)) {
                return false;
            }
            Integer this$employeeCompareLevel = this.getEmployeeCompareLevel();
            Integer other$employeeCompareLevel = other.getEmployeeCompareLevel();
            if (this$employeeCompareLevel == null ? other$employeeCompareLevel != null : !((Object)this$employeeCompareLevel).equals(other$employeeCompareLevel)) {
                return false;
            }
            Integer this$employeeTimeThreshold = this.getEmployeeTimeThreshold();
            Integer other$employeeTimeThreshold = other.getEmployeeTimeThreshold();
            if (this$employeeTimeThreshold == null ? other$employeeTimeThreshold != null : !((Object)this$employeeTimeThreshold).equals(other$employeeTimeThreshold)) {
                return false;
            }
            Integer this$employeeTrackThreshold = this.getEmployeeTrackThreshold();
            Integer other$employeeTrackThreshold = other.getEmployeeTrackThreshold();
            return !(this$employeeTrackThreshold == null ? other$employeeTrackThreshold != null : !((Object)this$employeeTrackThreshold).equals(other$employeeTrackThreshold));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PlatformReidConfigOutParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $dayReidEndHour = this.getDayReidEndHour();
            result = result * 59 + ($dayReidEndHour == null ? 43 : ((Object)$dayReidEndHour).hashCode());
            Integer $dayReidEndMinute = this.getDayReidEndMinute();
            result = result * 59 + ($dayReidEndMinute == null ? 43 : ((Object)$dayReidEndMinute).hashCode());
            Boolean $enableStorePasserby = this.getEnableStorePasserby();
            result = result * 59 + ($enableStorePasserby == null ? 43 : ((Object)$enableStorePasserby).hashCode());
            Integer $employeeBeginHour = this.getEmployeeBeginHour();
            result = result * 59 + ($employeeBeginHour == null ? 43 : ((Object)$employeeBeginHour).hashCode());
            Integer $employeeBeginMinute = this.getEmployeeBeginMinute();
            result = result * 59 + ($employeeBeginMinute == null ? 43 : ((Object)$employeeBeginMinute).hashCode());
            Integer $employeeBeginSecond = this.getEmployeeBeginSecond();
            result = result * 59 + ($employeeBeginSecond == null ? 43 : ((Object)$employeeBeginSecond).hashCode());
            Integer $employeeEndHour = this.getEmployeeEndHour();
            result = result * 59 + ($employeeEndHour == null ? 43 : ((Object)$employeeEndHour).hashCode());
            Integer $employeeEndMinute = this.getEmployeeEndMinute();
            result = result * 59 + ($employeeEndMinute == null ? 43 : ((Object)$employeeEndMinute).hashCode());
            Integer $employeeEndSecond = this.getEmployeeEndSecond();
            result = result * 59 + ($employeeEndSecond == null ? 43 : ((Object)$employeeEndSecond).hashCode());
            Boolean $employeeTimeMarkEnable = this.getEmployeeTimeMarkEnable();
            result = result * 59 + ($employeeTimeMarkEnable == null ? 43 : ((Object)$employeeTimeMarkEnable).hashCode());
            Integer $employeeCompareLevel = this.getEmployeeCompareLevel();
            result = result * 59 + ($employeeCompareLevel == null ? 43 : ((Object)$employeeCompareLevel).hashCode());
            Integer $employeeTimeThreshold = this.getEmployeeTimeThreshold();
            result = result * 59 + ($employeeTimeThreshold == null ? 43 : ((Object)$employeeTimeThreshold).hashCode());
            Integer $employeeTrackThreshold = this.getEmployeeTrackThreshold();
            result = result * 59 + ($employeeTrackThreshold == null ? 43 : ((Object)$employeeTrackThreshold).hashCode());
            return result;
        }

        public String toString() {
            return "DeviceFlowReidConfigReportAcl.PlatformReidConfigOutParam(dayReidEndHour=" + this.getDayReidEndHour() + ", dayReidEndMinute=" + this.getDayReidEndMinute() + ", enableStorePasserby=" + this.getEnableStorePasserby() + ", employeeBeginHour=" + this.getEmployeeBeginHour() + ", employeeBeginMinute=" + this.getEmployeeBeginMinute() + ", employeeBeginSecond=" + this.getEmployeeBeginSecond() + ", employeeEndHour=" + this.getEmployeeEndHour() + ", employeeEndMinute=" + this.getEmployeeEndMinute() + ", employeeEndSecond=" + this.getEmployeeEndSecond() + ", employeeTimeMarkEnable=" + this.getEmployeeTimeMarkEnable() + ", employeeCompareLevel=" + this.getEmployeeCompareLevel() + ", employeeTimeThreshold=" + this.getEmployeeTimeThreshold() + ", employeeTrackThreshold=" + this.getEmployeeTrackThreshold() + ")";
        }

        public PlatformReidConfigOutParam() {
        }
    }
}

