/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpUtils.class);

    public static String sendJsonToOtherServer(String url, Object data) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString((Object)data), Charset.forName("UTF-8")));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity);
                log.info("result = " + result);
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("sendJsonToOtherServer", (Throwable)e);
        }
        return result;
    }

    public static String sendPostToOtherServer(String url, Map<String, Object> params, Map<String, String> headers) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpPost.setHeader(entry.getKey(), entry.getValue());
            }
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse closeableHttpResponse = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = closeableHttpResponse.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = closeableHttpResponse.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                log.info("result = " + result);
                System.out.println(result);
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("sendPostToOtherServer", (Throwable)e);
        }
        return result;
    }

    public static String sendPostToOtherServer(String url, Map<String, Object> params) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity, (String)"UTF-8");
                log.info("result = " + result);
                System.out.println(result);
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("sendPostToOtherServer", (Throwable)e);
        }
        return result;
    }

    public static String sendPostToOtherServerWithAuth(String url, Map<String, Object> params, String authenticator) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            httpPost.setHeader("Ovo-Authorization", authenticator);
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity);
                log.info("result = " + result);
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("sendPostToOtherServer", (Throwable)e);
        }
        return result;
    }

    public static String sendPostToOtherServerWithAuthOld(String url, Map<String, Object> params, String authenticator) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            httpPost.setHeader("Ovo-Authorization", authenticator);
            ArrayList<BasicNameValuePair> pairList = new ArrayList<BasicNameValuePair>(params.size());
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                BasicNameValuePair pair = new BasicNameValuePair(entry.getKey(), entry.getValue().toString());
                pairList.add(pair);
            }
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairList, Charset.forName("UTF-8")));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity);
                log.info("result = " + result);
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("sendPostToOtherServer", (Throwable)e);
        }
        return result;
    }

    public static String sendJsonToOtherServerWithAuthOld(String url, Object data, String authenticator) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setHeader("authenticator", authenticator);
            httpPost.setEntity((HttpEntity)new StringEntity(JSONObject.toJSONString((Object)data), Charset.forName("UTF-8")));
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity, (Charset)Charset.forName("UTF-8"));
                log.info("result = " + result);
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("sendJsonToOtherServerWithAuthOld", (Throwable)e);
        }
        return result;
    }

    public static String sendGetToOtherServer(String url) {
        String result = "";
        try {
            CloseableHttpClient httpclient = HttpClients.createDefault();
            HttpGet httpPost = new HttpGet(url);
            httpPost.setHeader("Content-type", "application/json; charset=utf-8");
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(30000).setConnectionRequestTimeout(30000).setSocketTimeout(30000).build();
            httpPost.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity httpEntity = response.getEntity();
                result = EntityUtils.toString((HttpEntity)httpEntity, (String)"utf-8");
            } else {
                log.error("send url = " + url + " recv statusCode = " + statusCode);
            }
        }
        catch (Exception e) {
            log.error("sendPostToOtherServer", (Throwable)e);
        }
        return result;
    }

    public static String sendPostStr(String url, String param) {
        try {
            RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(3000).build();
            CloseableHttpClient httpclient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
            HttpPost httpPost = new HttpPost(url);
            httpPost.addHeader("Content-type", "application/json; charset=utf-8");
            httpPost.setHeader("Accept", "application/json");
            httpPost.setEntity((HttpEntity)new StringEntity(param, Charset.forName("UTF-8")));
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new RuntimeException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
                EntityUtils.consume((HttpEntity)entity);
                response.close();
                return result;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String url, Object params, Integer timeOut, Map<String, String> headers) throws Exception {
        if (timeOut == null) {
            timeOut = 10000;
        }
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeOut.intValue()).setConnectTimeout(timeOut.intValue()).build();
        CloseableHttpClient httpclient = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        httpPost.setConfig(requestConfig);
        httpPost.setHeader("Accept", "application/json");
        httpPost.setHeader("Content-Type", "application/json");
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpPost.setHeader(entry.getKey(), entry.getValue());
        }
        String charSet = "UTF-8";
        StringEntity entity = new StringEntity(JSON.toJSONString((Object)params), charSet);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse response = null;
        try {
            response = httpclient.execute((HttpUriRequest)httpPost);
            StatusLine status = response.getStatusLine();
            int state = status.getStatusCode();
            if (state == 200) {
                HttpEntity responseEntity = response.getEntity();
                String string = EntityUtils.toString((HttpEntity)responseEntity, (String)charSet);
                return string;
            }
            log.error("\u8bf7\u6c42\u8fd4\u56de:" + state + "(" + url + ")");
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                httpclient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

