/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.modules.platform;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.device.modules.platform.DeviceTrusteeshipService;
import com.ovopark.device.modules.platform.mysql.DeviceTrusteeship;
import com.ovopark.device.modules.platform.mysql.DeviceTrusteeshipLog;
import com.ovopark.device.modules.platform.mysql.DeviceTrusteeshipLogMapper;
import com.ovopark.device.modules.platform.mysql.DeviceTrusteeshipMapper;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeviceTrusteeshipServiceImpl
implements DeviceTrusteeshipService {
    private static final Logger log = LoggerFactory.getLogger(DeviceTrusteeshipServiceImpl.class);
    @Autowired
    private DeviceTrusteeshipMapper deviceTrusteeshipMapper;
    @Autowired
    private DeviceTrusteeshipLogMapper deviceTrusteeshipLogMapper;

    @Override
    public void add(Integer userId, @NotNull List<Integer> deviceStatusIds, @NotNull Integer targetGroupId) {
        LocalDateTime now = LocalDateTime.now();
        for (Integer deviceStatusId : deviceStatusIds) {
            List deviceTrusteeships = this.deviceTrusteeshipMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(DeviceTrusteeship::getTargetGroupId, (Object)targetGroupId)).eq(DeviceTrusteeship::getDeviceStatusId, (Object)deviceStatusId));
            if (!CollectionUtils.isEmpty((Collection)deviceTrusteeships)) continue;
            DeviceTrusteeship deviceTrusteeship = new DeviceTrusteeship();
            deviceTrusteeship.setDeviceStatusId(deviceStatusId);
            deviceTrusteeship.setCreateBy(userId);
            deviceTrusteeship.setCreateAt(now);
            deviceTrusteeship.setTargetGroupId(targetGroupId);
            int num = this.deviceTrusteeshipMapper.insert(deviceTrusteeship);
            if (num == 0) continue;
            DeviceTrusteeshipLog log = new DeviceTrusteeshipLog();
            log.setDeviceStatusId(deviceStatusId);
            log.setCreateBy(userId);
            log.setCreateAt(now);
            log.setTargetGroupId(targetGroupId);
            log.setType(DeviceTrusteeshipLog.TYPE_ADD);
            this.deviceTrusteeshipLogMapper.insert(log);
        }
    }

    @Override
    public void cancel(Integer userId, @NotNull List<Integer> deviceStatusIds, Integer targetGroupId) {
        for (Integer deviceStatusId : deviceStatusIds) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(DeviceTrusteeship::getDeviceStatusId, (Object)deviceStatusId)).eq(targetGroupId != null, DeviceTrusteeship::getTargetGroupId, (Object)targetGroupId);
            int delete = this.deviceTrusteeshipMapper.delete((Wrapper)queryWrapper);
            if (delete == 0) continue;
            DeviceTrusteeshipLog log = new DeviceTrusteeshipLog();
            log.setDeviceStatusId(deviceStatusId);
            log.setCreateBy(userId);
            log.setCreateAt(LocalDateTime.now());
            log.setTargetGroupId(targetGroupId);
            log.setType(DeviceTrusteeshipLog.TYPE_CANCEL);
            this.deviceTrusteeshipLogMapper.insert(log);
        }
    }

    @Override
    public List<DeviceTrusteeship> getDeviceTrusteeshipList(Integer targetGroupId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(DeviceTrusteeship::getTargetGroupId, (Object)targetGroupId);
        return this.deviceTrusteeshipMapper.selectList((Wrapper)queryWrapper);
    }
}

